USE hahn;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
PRAGMA yt.DefaultMaxJobFails = '1';

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;

PRAGMA yt.Pool = $yt_pool;


$parse_date = ($s) -> {
    RETURN CAST(SUBSTRING($s, 0, 4) || '-' || SUBSTRING($s, 4, 2) || '-' || SUBSTRING($s, 6, 2) AS Date)
};

$BNorm = ($query) -> {
    RETURN SUBSTRING(CAST(SearchRequest::NormalizeBert(CAST($query AS Utf8)) AS String), NULL, 500)
};

$queries = SELECT
    $parse_date(TableName()) AS day,
    ui,
    $BNorm(query) AS query,
    vsurplus["v7"]["all-SerpSummary"].win - vsurplus["v7"]["all-SerpSummary"].loss AS surplus_v7_serp
FROM RANGE(`//home/blender/surplus_squeeze/production`, String::RemoveAll($start_date, "-"), String::RemoveAll($end_date, "-"))
-- TABLESAMPLE SYSTEM(10.0) REPEATABLE(123)
WHERE service = 'www.yandex' AND ui IN ('desktop', 'touch');

$cluster_data = SELECT
    True AS is_cluster,
    day,
    ui,
    CAST(cluster AS String) AS cluster,
    COUNT(*) AS queries,
    SUM(surplus_v7_serp) AS surplus_v7_sum
FROM (
    SELECT
        day,
        ui,
        surplus_v7_serp,
        b.ClusterID AS cluster
    FROM $queries AS a
    LEFT JOIN ANY `//home/searchshare/common/query_to_cluster` AS b
    USING(query)
    WHERE surplus_v7_serp IS NOT NULL
)
GROUP BY day, ui, cluster;

$flow_data = SELECT
    False AS is_cluster,
    day,
    ui,
    'all_clusters' AS cluster,
    SUM(queries) AS queries,
    SUM(surplus_v7_sum) AS surplus_v7_sum
FROM $cluster_data
GROUP BY day, ui;

$output_data = (
	SELECT * FROM $cluster_data
	UNION ALL
	SELECT * FROM $flow_data
);

$old_data = (
	SELECT * WITHOUT cluster_name, middle_cluster_name, parent_cluster_name
	FROM `//home/searchshare/dashboard/cube_datasets/surplus` 
	WHERE CAST(day AS String) NOT BETWEEN $start_date AND $end_date
);

INSERT INTO `//home/searchshare/dashboard/cube_datasets/surplus` WITH TRUNCATE
SELECT * FROM $output_data
UNION ALL
SELECT * FROM $old_data
ORDER BY cluster, day;
