USE hahn;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
PRAGMA yt.DefaultMaxJobFails = '1';
PRAGMA yt.TemporaryAutoMerge = 'disabled';

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;

PRAGMA yt.Pool = $yt_pool;

$start_month = DateTime::Format("%Y-%m")(CAST($start_date AS Date));
$end_month = DateTime::Format("%Y-%m")(DateTime::ShiftMonths(CAST($end_date AS Date), -1));


$query_stats = SELECT
    month,
    ui,
    cluster,
    query,
    COUNT(*) AS cnt,
    SUM(revenue) AS revenue,
    COUNT_IF(CAST(prism_cluster AS Int32) >= 95) AS prism_95_cnt,
    SUM_IF(revenue, CAST(prism_cluster AS Int32) >= 95) AS prism_95_revenue
FROM RANGE("//home/searchshare/squeeze_cube", $start_month, $end_month)
GROUP BY TableName() AS month, ui, CAST(cluster AS String) AS cluster, query;


$top_queries_by_count = SELECT
    month,
    ui,
    cluster,
    qt.1 AS query,
    qt.0 AS cnt,
    qt.2 AS revenue
FROM (
    SELECT
        month,
        ui,
        cluster,
        TOP((cnt, query, revenue), 20) AS q_list
    FROM $query_stats
    GROUP BY month, ui, cluster
)
FLATTEN LIST BY q_list AS qt;


$prism_top_queries_by_count = SELECT
    month,
    ui,
    cluster,
    qt.1 AS query,
    qt.0 AS cnt,
    qt.2 AS revenue
FROM (
    SELECT
        month,
        ui,
        cluster,
        TOP((prism_95_cnt, query, prism_95_revenue), 20) AS q_list
    FROM $query_stats
    GROUP BY month, ui, cluster
)
FLATTEN LIST BY q_list AS qt;



$top_queries_by_revenue = SELECT
    month,
    ui,
    cluster,
    qt.1 AS query,
    qt.0 AS revenue,
    qt.2 AS cnt
FROM (
    SELECT
        month,
        ui,
        cluster,
        TOP((revenue, query, cnt), 20) AS q_list
    FROM $query_stats
    GROUP BY month, ui, cluster
)
FLATTEN LIST BY q_list AS qt;


$prism_top_queries_by_revenue = SELECT
    month,
    ui,
    cluster,
    qt.1 AS query,
    qt.0 AS revenue,
    qt.2 AS cnt
FROM (
    SELECT
        month,
        ui,
        cluster,
        TOP((prism_95_revenue, query, prism_95_cnt), 20) AS q_list
    FROM $query_stats
    GROUP BY month, ui, cluster
)
FLATTEN LIST BY q_list AS qt;


$old_data = SELECT * FROM `//home/searchshare/dashboard/cube_datasets/top_queries`
WHERE month NOT BETWEEN $start_month AND $end_month;


$res = SELECT a.*, 'count' AS type FROM $top_queries_by_count AS a
UNION ALL
SELECT a.*, 'prism_95_count' AS type FROM $prism_top_queries_by_count AS a
UNION ALL
SELECT a.*, 'revenue' AS type FROM $top_queries_by_revenue AS a
UNION ALL
SELECT a.*, 'prism_95_revenue' AS type FROM $prism_top_queries_by_revenue AS a;


$new_data = SELECT * FROM $res AS r
LEFT JOIN ANY (
    SELECT cluster_id AS cluster, cluster_name, middle_cluster_name, parent_cluster_name
    FROM `//home/searchshare/dashboard/cluster_tree`
) AS t
USING(cluster);


INSERT INTO `//home/searchshare/dashboard/cube_datasets/top_queries` WITH TRUNCATE 
SELECT * FROM $old_data
UNION ALL
SELECT * FROM $new_data;
