USE hahn;

PRAGMA yson.DisableStrict = '1';
PRAGMA yt.TemporaryAutoMerge = 'disabled';

$tree = (
    SELECT cluster_id AS cluster, cluster_name, middle_cluster_name, parent_cluster_name
    FROM `//home/searchshare/dashboard/cluster_tree`
);

$table_list = AsList(
    -- "//home/searchshare/dashboard/clusters/small_clusters_aggregation",
    -- "//home/searchshare/dashboard/clusters/small_clusters_aggregation_cutted_YoY",
    -- "//home/searchshare/dashboard/clusters/small_clusters_aggregation_tech",
    -- "//home/searchshare/dashboard/clusters/tops/top_queries",
    -- "//home/searchshare/dashboard/clusters/tops/top_queries_c2",
    "//home/searchshare/dashboard/cube_datasets/cluster_data_by_day_and_ui",
    "//home/searchshare/dashboard/cube_datasets/cluster_revenue",
    "//home/searchshare/dashboard/cube_datasets/queries",
    "//home/searchshare/dashboard/cube_datasets/surplus",
    "//home/searchshare/dashboard/cube_datasets/top_queries_by_count",
    "//home/searchshare/dashboard/cube_datasets/top_queries_by_revenue"
);

EVALUATE FOR $table IN $table_list DO BEGIN
    $data = (
        SELECT
            CAST(cluster AS String) AS cluster,
            t.* WITHOUT cluster_name, middle_cluster_name, parent_cluster_name, cluster
        FROM $table AS t
    );
    
    INSERT INTO $table WITH TRUNCATE
    SELECT d.*,
        cluster_name, middle_cluster_name, parent_cluster_name
    FROM $data AS d
    LEFT JOIN ANY $tree AS t
    USING(cluster)
    ORDER BY cluster
END DO;
