USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA yt.MapJoinLimit = "6144M";

PRAGMA library("common.sql");
PRAGMA library("define_cluster_lib.sql");

IMPORT common SYMBOLS $date_range_inclusive, $normalize_query;
IMPORT define_cluster_lib SYMBOLS $define_cluster;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $source_name AS String;
DECLARE $squeeze_path AS String;
DECLARE $tmp_squeeze_path AS String;
DECLARE $common_path AS String?;

PRAGMA yt.Pool = $yt_pool;

$common_path = $common_path ?? "//home/searchshare/common";

define subquery $sessions() as
    $remove_columns_list = [
        "c_clusters",
        "cl_father",
        "h_clusters",
        "h_fathers",
        "h_host",
        "norm_query",
        "q_cluster",
        "session_class",
    ];

    select *
    from (
        select
            ForceRemoveMembers(TableRow(), $remove_columns_list),
            TableName(TablePath(), "yt") as day,
            $normalize_query(query_text) as norm_query,
        from range($squeeze_path || "/" || $source_name, $start_date, $end_date)
    )
    flatten columns;
end define;

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $dst = $tmp_squeeze_path || "/" || $source_name || "/" || $dt;

    INSERT INTO $dst WITH TRUNCATE
    SELECT *
    WITHOUT day
    FROM $define_cluster($sessions, $start_date, $end_date, "hahn", $common_path)
    WHERE day = $dt
    ORDER BY user_id, start_ts;
END DO;
