USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA yt.QueryCacheTtl = "3d";
PRAGMA yt.CombineCoreLimit = "2G";

PRAGMA library('common.sql');
PRAGMA library('enrich_crypta_lib.sql');
PRAGMA library('enrich_prism_lib.sql');

IMPORT common SYMBOLS $date_range_inclusive;
IMPORT enrich_crypta_lib SYMBOLS $enrich_crypta, $add_yuid_to_similar;
import enrich_prism_lib symbols $enrich_prism_subquery;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $squeeze_path AS String;
DECLARE $tmp_squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

$source_name = "similar";

define subquery $sessions() as
    $remove_columns_list = [
        "socdem",
        "C2_prob",
        "crypta_id",
        "CPT",
        "cluster",
        "norm_serp_revenue",
    ];

    select *
    from (
        select
            ForceRemoveMembers(TableRow(), $remove_columns_list),
            TableName(TablePath(), "yt") as day,
        from range($squeeze_path || "/" || $source_name, $start_date, $end_date)
    )
    flatten columns;
end define;

$stream = $add_yuid_to_similar($sessions, $start_date, $end_date, "hahn");
$stream_with_prism = $enrich_prism_subquery($stream, $start_date, $end_date, "hahn");

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $out = $tmp_squeeze_path || "/" || $source_name || "/" || $dt;

    INSERT INTO $out WITH TRUNCATE
    SELECT *
    WITHOUT day, yandexuid
    FROM $enrich_crypta($stream_with_prism, $start_date, $end_date, "hahn")
    WHERE day = $dt
    ORDER BY user_id, start_ts;
END DO;
