USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA yt.TemporaryAutoMerge = "disabled";
PRAGMA yt.QueryCacheTtl = "3d";
PRAGMA yt.CombineCoreLimit = "2G";

PRAGMA library('common.sql');
PRAGMA library('enrich_money_lib.sql');
PRAGMA library('enrich_prism_lib.sql');

IMPORT common SYMBOLS $date_range_inclusive;
import enrich_money_lib symbols $add_yuid_to_spylog;
import enrich_prism_lib symbols $enrich_with_prism;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $squeeze_path AS String;
DECLARE $tmp_squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

$source_name = "spylog";

define subquery $sessions() as
    $remove_columns_list = [
        "CPT",
        "cluster",
        "norm_serp_revenue",
    ];

    select *
    from (
        select
            ForceRemoveMembers(TableRow(), $remove_columns_list),
            TableName(TablePath(), "yt") as day,
        from range($squeeze_path || "/" || $source_name, $start_date, $end_date)
    )
    flatten columns;
end define;

$stream_with_yuid = $add_yuid_to_spylog($sessions, $start_date, $end_date, "hahn");

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $dst = $tmp_squeeze_path || "/" || $source_name || "/" || $dt;

    insert into $dst with truncate
    select *
    without day, yandexuid
    from $enrich_with_prism($stream_with_yuid, $start_date, $end_date, "hahn")
    where day = $dt
    order by user_id, start_ts;
end do;
