USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA library('lib.sql') ;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

IMPORT lib SYMBOLS $date_range_inclusive, $enrich_with_money;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $squeeze_path AS String;
DECLARE $tmp_squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

DEFINE SUBQUERY $sessions($start_date, $end_date, $cluster) AS
    SELECT
        0 AS priority,
        TableName(TablePath(), "yt") AS day,
        s.c_clusters AS c_clusters,
        s.cl_father AS cl_father,
        s.duration AS duration,
        s.end_host AS end_host,
        s.end_point AS end_point,
        s.end_type AS end_type,
        s.enter_host AS enter_host,
        s.enter_point AS enter_point,
        s.enter_type AS enter_type,
        s.h_clusters AS h_clusters,
        s.h_fathers AS h_fathers,
        s.hits AS hits,
        s.norm_query AS norm_query,
        s.q_cluster AS q_cluster,
        s.query_list AS query_list,
        s.query_text AS query_text,
        s.session_class AS session_class,
        s.session_id AS session_id,
        s.src AS src,
        s.start_ts AS start_ts,
        s.ui AS ui,
        s.user_id AS user_id,
        s.user_region AS user_region,
        s.useragent AS useragent,
    FROM yt:$cluster.RANGE($squeeze_path || "/spylog", $start_date, $end_date) AS s;
END DEFINE;

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $dst = $tmp_squeeze_path || "/spylog/" || $dt;

    INSERT INTO $dst WITH TRUNCATE
    SELECT * FROM $enrich_with_money($sessions, $start_date, $end_date, "hahn")
    WHERE day = $dt
    ORDER BY user_id, start_ts;
END DO;
