USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;

PRAGMA library('common.sql') ;

IMPORT common SYMBOLS $date_range_inclusive;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

$get_yandexyuid = ($event_value) -> (
    Yson::LookupString(
        Yson::ParseJson($event_value, Yson::Options(False AS Strict)),
        "yandexuid.ru",
        Yson::Options(False AS Strict)
    )
);

$icookie_to_yuid = (
    SELECT DISTINCT *
    FROM (
        SELECT
            TableName() AS day,
            "y" || _logfeller_icookie AS user_id,
            $get_yandexyuid(EventValue) AS yandexuid,
        FROM RANGE("//logs/superapp-metrika-mobile-log/1d", $start_date, $end_date)
        WHERE
            APIKey = 10321
            AND EventType = 4
            AND EventName = "url opened"
            AND $get_yandexyuid(EventValue) IS NOT NULL
            AND _logfeller_icookie IS NOT NULL

        UNION ALL

        SELECT
            TableName() AS day,
            "y" || _logfeller_icookie AS user_id,
            $get_yandexyuid(EventValue) AS yandexuid,
        FROM RANGE("//logs/browser-metrika-mobile-log/1d", $start_date, $end_date)
        WHERE
            APIKey = 106400
            AND EventType = 4
            AND EventName = "url opened"
            AND $get_yandexyuid(EventValue) IS NOT NULL
            AND _logfeller_icookie IS NOT NULL
    )
);

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $out = $squeeze_path || "/icookie_to_yuid/" || $dt;

    INSERT INTO $out WITH TRUNCATE
    SELECT *
    FROM $icookie_to_yuid
    WHERE day = $dt
    ORDER BY day, user_id;
END DO;
