PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$max_query_length = 500;

$get_host = ($url) -> {
    $host = Url::CutWWW2(Url::GetOwner($url));
    $is_ya = (
        IF(Url::GetSignificantDomain($url) LIKE "yandex.%" OR Url::GetSignificantDomain($url) LIKE "%.yandex",
            1, 0)
    );

    $yaservice = IF(
        Url::GetDomain($host,2) LIKE "%.yandex",
        String::SplitToList(Url::GetDomain($host, 2), '.')[0],
        IF(
            Url::GetDomain($host,3) IS NOT NULL,
            IF(
                String::SplitToList(Url::GetDomain($host,3), '.')[0] == "yandex",
                String::SplitToList(Url::GetDomain($host,4), '.')[0],
                String::SplitToList(Url::GetDomain($host,3), '.')[0]
            ),
            String::SplitToList(Url::GetPath($url), '/')[1]
        )
    );
    $otherhost = IF($host LIKE "m.%",
        Substring($host,  2),
        Url::ForcePunycodeToHostName($host)
    );

    $yahost = IF($is_ya == 1,  $yaservice || ".yandex.ru", $otherhost
    );

    RETURN IF(
        Url::GetDomain(Url::GetOwner($url), 2) IS NUll,
        NULL,
        Cast(String::AsciiToLower($yahost) as string)
    );
};

$replace_whitespaces = Re2::Replace(@@\s+@@);
$clean_query = ($query) -> (
    String::Strip($replace_whitespaces($query, " "))
);

$make_url_type = ($url) -> {
    $host = String::AsciiToLower(Url::GetHost($url));
    $path = String::AsciiToLower(Url::GetPath($url));
    $is_people = Url::GetCGIParam($url, "filter") == "people";

    RETURN CASE
        WHEN $host LIKE "clck.yandex.%" OR $host LIKE "%.clck.yandex.%" THEN "WEB"
        WHEN $host LIKE "images.yandex.%" OR $host LIKE "%.images.yandex.%" THEN "IMAGES"
        WHEN $host LIKE "maps.yandex.%" OR $host LIKE "%.maps.yandex.%" THEN "MAPS"
        WHEN $host LIKE "market.yandex.%" OR $host LIKE "%.market.yandex.%" THEN "COM"
        WHEN $host LIKE "music.yandex.%" OR $host LIKE "%.music.yandex.%" THEN "MUSIC"
        WHEN $host LIKE "news.yandex.%" OR $host LIKE "%.news.yandex.%" THEN "NEWS"
        WHEN $host LIKE "rabota.yandex.%" OR $host LIKE "%.rabota.yandex.%" THEN "JOB"
        WHEN $host LIKE "slovari.yandex.%" OR $host LIKE "%.slovari.yandex.%" THEN "ENCYC"
        WHEN $host LIKE "video.yandex.%" OR $host LIKE "%.video.yandex.%" THEN "VIDEO"
        WHEN $host LIKE "yabs.yandex.%" OR $host LIKE "%.yabs.yandex.%" THEN "ADV_SERP"
        WHEN $host LIKE "zen.yandex.%" OR $host LIKE "%.zen.yandex.%" THEN "ZEN"
        WHEN $host LIKE "taxi.yandex.%" OR $host LIKE "%.taxi.yandex.%" THEN "TAXI"

        WHEN $host LIKE "%yandex.%" AND $path LIKE "/clck%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/gorsel%" THEN "IMAGES"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/images%" THEN "IMAGES"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/msearch%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/search%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/searchapp%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/sitesearch%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/touchsearch%" AND $is_people THEN "PEOPLE"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/touchsearch%" THEN "WEB"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/video%" THEN "VIDEO"
        WHEN $host LIKE "%yandex.%" AND $path LIKE "/yandsearch%" THEN "WEB"

        ELSE SearchEngine::Info($url).Type
    END;
};

$make_url_name = ($url) -> {
    $host = String::AsciiToLower(Url::GetHost($url));

    RETURN IF(
        $host LIKE "%yandex.%",
        "YANDEX",
        SearchEngine::Info($url).Name
    );
};

$make_query = ($url) -> {
    $host = String::AsciiToLower(Url::GetHost($url));
    $path = String::AsciiToLower(Url::GetPath($url));

    $query = CASE
        WHEN $host LIKE "%yandex.%" AND $path LIKE "%/search%"
            THEN $clean_query(Url::GetCGIParam(String::ReplaceAll($url, "text=#", "text=%23"), "text"))
        WHEN SearchEngine::Is($url)
            THEN SearchEngine::Info($url).Query
        ELSE NULL
    END;
    RETURN Url::Decode($query);
};

$get_is_search = ($url) -> {
    $host = String::AsciiToLower(Url::GetHost($url));
    $path = String::AsciiToLower(Url::GetPath($url));

    RETURN $host LIKE "%yandex.%" AND $path LIKE "%/search%" OR SearchEngine::Is($url);
};

$get_url_info = ($url) -> (
    <|
        'name': $make_url_name($url),
        'type': $make_url_type($url),
        'query': $make_query($url),
        'is_search': $get_is_search($url),
        'host': $get_host($url),
        'url': $url,
    |>
);

$normalize_query = ($query) -> (
    SUBSTRING($query ?? "", NULL, $max_query_length)
);

$datestr = DateTime::Format("%Y-%m-%d");

$date_range_inclusive = ($start_date_str, $end_date_str) -> {
    $start_date = CAST($start_date_str AS Date);
    $end_date = CAST($end_date_str AS Date);

    RETURN ListCollect(ListMap(ListFromRange(0, (DateTime::ToDays($end_date-$start_date)+1) ?? 0), ($x) -> (
        $datestr($start_date + DateTime::IntervalFromDays(CAST($x AS Int16)))
    )));
};

$shift_date = ($start_date, $shift) -> (
    $datestr(CAST($start_date AS Date) + DateTime::IntervalFromDays($shift))
);

$check_ts = ($day, $ts) -> {
    $msk_ts = AddTimezone(DateTime::FromSeconds(CAST($ts AS Uint32)), 'Europe/Moscow');
    return $ts > 100000 and Cast($day || ",Europe/Moscow" As TzDate) = Cast($msk_ts AS TzDate);
};

$day_from_path = ($path) -> (
    listreverse(String::SplitToList($path, "/"))[1]
);

$get_os = ($platform) -> (
    if(
        String::AsciiToLower($platform) in ("android", "ios", "linux", "macos", "windows"),
        String::AsciiToLower($platform),
        "other"
    )
);

export $normalize_query, $date_range_inclusive, $shift_date, $check_ts, $day_from_path, $get_os, $get_url_info, $get_host;
