define subquery $enrich_with_prism($stream, $start_date, $end_date, $cluster) as
    $prism = (
        select
            TableName(TablePath(), "yt") AS day,
            t.*,
        from yt:$cluster.range("//home/prism/user_weights", $start_date, $end_date) as t
    );

    select
        s.*,
        pr.CPT as CPT,
        pr.cluster as cluster,
        pr.norm_serp_revenue as norm_serp_revenue,
    from $stream() as s
    left join any $prism as pr
    using (day, yandexuid);
end define;

$enrich_prism_subquery = ($stream, $start_date, $end_date, $cluster) -> (
    ($world) -> (
        $enrich_with_prism($world, $stream, $start_date, $end_date, $cluster)
    )
);

export $enrich_with_prism, $enrich_prism_subquery;
