PRAGMA AnsiInForEmptyOrNullableItemsCollections;

import common symbols $check_ts, $day_from_path, $get_os, $get_url_info, $get_host;

DEFINE SUBQUERY $similar_events($start_date, $end_date, $cluster) AS
    $desktop = (
        SELECT
            $day_from_path(TablePath()) AS day,
            key_uid AS uid,
            subkey_unixtime AS unixtime,
            $get_url_info(TSKV_DATA.stuff_dict["url"]) AS url_info,
            $get_url_info(TSKV_DATA.referer) AS referer_info,
            TSKV_DATA.user_region AS user_region,
            "desktop" AS ui,
            TSKV_DATA.u_agent AS useragent,
            "similar" AS src,
            $get_os(UserAgent::Parse(TSKV_DATA.u_agent).OSFamily) as os,
        from yt:$cluster.Range("//user_sessions/pub/similargroup/daily", $start_date, $end_date, "clean")
        where type == "TRAFFIC"
            and (TSKV_DATA.stuff_dict["url"] like "https://%" or TSKV_DATA.stuff_dict["url"] like "http://%")
            and Geo::RoundRegionById(Cast(TSKV_DATA.user_region AS Int32), "country").en_name == "Russia"
            and $check_ts($day_from_path(TablePath()), subkey_unixtime)
            and $get_host(TSKV_DATA.stuff_dict["url"]) is not null
    );

    SELECT * FROM $desktop;
END DEFINE;

$get_ui = ($stuff_dict) -> (
    if(
        $stuff_dict["from-mobile-device"] == "1"
        or $stuff_dict["api-key"] is not null
        or $stuff_dict["yasoft"] in ["android.yabrowser", "apad.yabrowser", "ipad.yabrowser", "iphone.yabrowser"],
        "touch",
        "desktop"
    )
);

DEFINE SUBQUERY $spylog_events($start_date, $end_date, $cluster) AS
    SELECT
        $day_from_path(TablePath()) AS day,
        key_uid AS uid,
        $get_url_info(TSKV_DATA.stuff_dict["url"]) AS url_info,
        $get_url_info(TSKV_DATA.referer) AS referer_info,
        TSKV_DATA.user_region AS user_region,
        $get_ui(TSKV_DATA.stuff_dict) as ui,
        subkey_unixtime AS unixtime,
        TSKV_DATA.u_agent AS useragent,
        "spylog" AS src,
        $get_os(TSKV_DATA.stuff_dict["platform"]) as os,
    from yt:$cluster.Range("//user_sessions/pub/spy_log_v2/daily", $start_date, $end_date, "clean")
    where type == "TRAFFIC"
        and (TSKV_DATA.stuff_dict["url"] like "https://%" or TSKV_DATA.stuff_dict["url"] like "http://%")
        and Geo::RoundRegionById(Cast(TSKV_DATA.user_region AS Int32), "country").en_name == "Russia"
        and $check_ts($day_from_path(TablePath()), subkey_unixtime)
        and $get_host(TSKV_DATA.stuff_dict["url"]) is not null;
END DEFINE;

EXPORT $similar_events, $spylog_events;
