$info_type = Struct<is_search:Bool?,name:String?,type:String?,query:String?,host:String?,url:String?>;

$make_session_reducer = Python2::make_session(
    Callable<(
        Tuple<String?, String, String?>,
        Stream<
            Struct<
                'day':String?,
                'referer_info':$info_type,
                'src':String,
                'ui':String,
                'uid':String?,
                'unixtime':Uint64?,
                'url_info':$info_type,
                'user_region':Uint32?,
                'useragent':String?,
                'os':String?,
            >
        >
    ) -> Stream<
        Struct<
            'day':String,
            'duration':Uint32,
            'end_host':String?,
            'end_point':String?,
            'end_type':String?,
            'enter_host':String?,
            'enter_point':String?,
            'enter_type':String?,
            'hits':Uint32,
            'norm_query':String?,
            'query_count':Int32,
            'query_list':List<String>,
            'query_text':String,
            'referer_query':String?,
            'session_id':String,
            'src':String,
            'start_ts':Uint64,
            'ui':String,
            'user_id':String,
            'user_region':Uint32,
            'useragent':String?,
            'os':String,
        >
    >>,
    FileContent("make_sessions.py")
);

DEFINE SUBQUERY $make_sessions($stream, $start_date, $end_date, $cluster) AS
    REDUCE $stream($start_date, $end_date, $cluster)
    PRESORT unixtime, Substring(referer_info.url, NULL, 2000), Substring(url_info.url, NULL, 2000)
    ON day, src, uid
    USING $make_session_reducer(TableRow());
END DEFINE;

$make_sessions_stream = ($stream, $start_date, $end_date, $cluster) -> (
    ($world) -> (
        $make_sessions($world, $stream, $start_date, $end_date, $cluster)
    )
);

export $make_sessions, $make_sessions_stream;
