USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA yt.MapJoinLimit = "6144M";

PRAGMA library('common.sql');
PRAGMA library('events.sql');
PRAGMA library('make_sessions_lib.sql');

IMPORT common SYMBOLS $date_range_inclusive;
IMPORT events SYMBOLS $similar_events;
IMPORT make_sessions_lib SYMBOLS $make_sessions;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $out = $squeeze_path || "/similar/" || $dt;

    INSERT INTO $out WITH TRUNCATE
    SELECT *
    WITHOUT day
    FROM $make_sessions($similar_events, $start_date, $end_date, "hahn")
    WHERE day = $dt
    ORDER BY user_id, start_ts;
END DO;
