use arnold;

pragma yt.PoolTrees = 'physical';
pragma yt.TentativePoolTrees = 'cloud';

declare $yt_pool as String;
declare $expansions_path as String;
declare $output_path as String;

PRAGMA yt.Pool = $yt_pool;

$PrepareExtensions = ($extensions) -> (
    String::JoinFromList(
        ListMap(
            ListTake(ListSortDesc($extensions, ($x) -> ($x.1)), 10),
            ($x) -> (Cast($x.0 as Utf8))
        ),
        " "
    )
);

insert into $output_path with truncate
select
    QueryQdoppGroup as Qdopp,
    $PrepareExtensions(aggregate_list((Expansion, ExpansionWeight))) as Ext_Qfuf_Top10,
from $expansions_path
group by QueryQdoppGroup
order by Qdopp;
