USE hahn;

PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;

PRAGMA library("common.sql");

IMPORT common SYMBOLS $date_range_inclusive, $get_url_info;

DECLARE $start_date AS String;
DECLARE $end_date AS String;
DECLARE $yt_pool AS String;
DECLARE $source_name AS String;
DECLARE $squeeze_path AS String;
DECLARE $tmp_squeeze_path AS String;

PRAGMA yt.Pool = $yt_pool;

$make_class = ($info) -> {
    RETURN CASE
        WHEN $info.host IS NULL THEN "NATIVE"
        WHEN $info.name IS NOT NULL AND $info.name != "UNKNOWN" THEN $info.name || " " || $info.type
        ELSE $info.host
    END
};

EVALUATE FOR $dt IN $date_range_inclusive($start_date, $end_date) DO BEGIN
    $in = $squeeze_path || "/" || $source_name || "/" || $dt;
    $out = $tmp_squeeze_path || "/" || $source_name || "/" || $dt;

    INSERT INTO $out WITH TRUNCATE
    SELECT
        t.*,
        $make_class($get_url_info(enter_url)) AS enter_type,
        $make_class($get_url_info(end_url)) AS end_type,
    WITHOUT enter_type
    FROM $in AS t
    ASSUME ORDER BY user_id, start_ts;
END DO;
