import os
import subprocess
import re
import sys

import attr

__author__ = 'irlab'

class Screenshotter:
    RESOLUTION_DESKTOP = "683;1020"
    TIMEOUT = '2m'

    def __init__(self, phantomjs_path, env=None, verbose=False):
        self.phantomjs_path = phantomjs_path
        self.verbose = verbose
        self.env = env
        self.resolution = self.RESOLUTION_DESKTOP

    def make_screenshots(self, html, selector, out_dir):
        fname = os.path.join(out_dir, "d")
        with open(fname + ".html", 'wb') as fo:
            fo.write(html)
        assert os.path.isfile(self.phantomjs_path)

        useagent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 YaBrowser/15.10.2454.3865 Safari/537.36"
        cmd = ['timeout',
               self.TIMEOUT,
               self.phantomjs_path,
               "make_screen.js",
               "file:///" + os.path.abspath(fname + ".html").replace('\\', '/'),
               fname + "_",
               self.resolution,
               useagent,
               selector,
               "1"]
        if os.name == 'nt':
            # cmd = cmd[2:]
            return []

        if self.verbose:
            print ">>", cmd[0] + ' ' + ' '.join('"%s"' % c for c in cmd[1:])
        cmdout = subprocess.check_output(cmd, env=self.env)

        image_list = []
        """:type : list[Image]"""

        for l in cmdout.split('\n'):
            m = re.search(r'Screenshot done for .*? -> (\S+((_[\d\w]+){6})\.png)', l)
            if not m: continue
            image = Image()
            image.filename = m.group(1)
            # if not os.path.isfile(image.filename):
            #     print "[WARN] file does not exists " + image.filename
            #     continue
            num, image.seanid, top, left, width, height = m.group(2).strip('_').split('_')
            image.top, image.left, image.width, image.height = map(int, (top, left, width, height))
            image_list.append(image)
            if os.path.isfile(image.filename):
                with open(image.filename) as f:
                    image.binary_content = f.read()
        return image_list


@attr.s
class Image(object):
    filename = attr.ib(type=str, default=None)
    seanid = attr.ib(type=str, default=None)
    top = attr.ib(type=int, default=None)
    left = attr.ib(type=int, default=None)
    width = attr.ib(type=int, default=None)
    height = attr.ib(type=int, default=None)
    binary_content = attr.ib(type=str, default=None)
