import json
import os
import time
from SerpParser import SerpElementExampleSet

from settings import SerpSettings

__author__ = 'irlab'

class Onto:
    def __init__(self):
        self.meta = OntoMeta()
        self.groups = []
        """:type : list[OntoElement]"""

class OntoMeta:
    def __init__(self):
        self.create_date = time.ctime()
        self.queries_count = 0
        self.serp_elements_count = 0
        self.groups_count = 0


class OntoElement:
    def __init__(self):
        self.queries_count = 0
        self.serp_elements_count = 0
        self.skeleton = ""
        self.short_skeleton = ""
        self.short_skeletons_num = 1
        self.examples = []
        """:type : list[OntoElementExample]"""


class OntoElementExample:
    def __init__(self):
        self.query_text = u''
        self.serp_id = ""
        self.serp_url_static = ""
        self.element_id = ""
        self.screenshot_filename = None
        self.screenshot_url_static = None
        self.top = None
        self.left = None
        self.width = None
        self.height = None


class SerpSet2Json:
    def __init__(self, serp_settings, uuid_folder):
        self.serp_settings = serp_settings
        assert isinstance(self.serp_settings, SerpSettings)
        self.uuid_folder = uuid_folder

    def create_out_json(self, out_dir, serp_list, example_sets):
        print time.ctime(), "create_out_json"
        try:
            os.mkdir(out_dir)
        except:
            pass
        onto = self.create_onto(serp_list, example_sets)
        with open(os.path.join(out_dir, "onto.json"), 'wb') as fo:
            json.dump(onto, fo, ensure_ascii=True, indent=1, default=lambda o: o.__dict__)

    def create_onto(self, serp_list, example_sets):
        example_sets.sort(key=lambda ex: (ex.short_skeleton, ex.skeleton))

        onto = Onto()
        onto.meta.queries_count = len(serp_list)
        onto.meta.serp_elements_count = sum(ex.serp_elem_count for ex in example_sets)
        onto.meta.groups_count = len(example_sets)
        for example_set in example_sets:
            assert isinstance(example_set, SerpElementExampleSet)
            onto_element = OntoElement()
            onto_element.queries_count = example_set.query_count

            if onto_element.queries_count <= self.serp_settings.HTM_SERP_ELEMENTS_SKIP_IF_QUERIES_LE:
                continue

            onto_element.serp_elements_count = example_set.serp_elem_count
            onto_element.skeleton = example_set.skeleton
            onto_element.short_skeleton = example_set.short_skeleton
            onto_element.short_skeletons_num = len(example_set.short_skeleton_set)
            onto_element.examples = self.create_onto_element_example_list(example_set.serp_elem_list)
            if not onto_element.examples:
                continue
            onto.groups.append(onto_element)

        return onto

    def create_onto_element_example_list(self, serp_elem_list):
        onto_element_example_list = []
        if not serp_elem_list:
            return
        seanid_serp_elem_pairs = sorted([(se.seanid, se) for se in serp_elem_list])
        for serp_elem_num, (seanid, serp_elem) in enumerate(seanid_serp_elem_pairs):
            if serp_elem_num >= self.serp_settings.HTM_SERP_ELEMENTS_SAMPLE_COUNT:
                break
            ex = OntoElementExample()
            ex.query_text = serp_elem.query_text
            ex.serp_id = serp_elem.serp_id
            ex.serp_url_static = self.uuid_folder + "/" + serp_elem.serp_id + "/d.html"
            ex.element_id = serp_elem.seanid

            if serp_elem.image:
                ex.screenshot_filename = os.path.basename(serp_elem.image.filename)
                ex.screenshot_url_static = self.uuid_folder + "/" + serp_elem.serp_id + "/" + ex.screenshot_filename
                ex.top = serp_elem.image.top
                ex.left = serp_elem.image.left
                ex.width = serp_elem.image.width
                ex.height = serp_elem.image.height
            onto_element_example_list.append(ex)

        return onto_element_example_list
