#coding: utf8

from urllib import urlencode
from django.utils import simplejson
from django.http import HttpResponse
from django.utils.functional import wraps
from django.template import RequestContext
from django.shortcuts import render_to_response
from settings import LOCAL_ENVIRONMENT, SITE_URL
from django.contrib.auth.decorators import user_passes_test

def render_to(t=''):
    def wrapper(fun):
        def new(request, *args, **kwargs):
            context = fun(request, *args, **kwargs)
            if not isinstance(context, dict):
                return context
            ret = render_to_response(t, context, context_instance=RequestContext(request))
            #if request.user.is_authenticated():
            #    ret['X-Accel-Expires'] = 0
            return ret
        return wraps(fun)(new)
    return wrapper


def jsonify(*args, **kwargs):
    opts = {}
    opts.update(kwargs or {'ensure_ascii': False})
    def wrapper(fun):
        def new(request, *args, **kwargs):
            ret = fun(request, *args, **kwargs)
            if not isinstance(ret, (dict, list, tuple)):
                return ret

            if isinstance(ret, tuple):
                return HttpResponse(simplejson.dumps(ret[1], **opts), mimetype='application/json; charset=utf-8', status=ret[0])

            return HttpResponse(simplejson.dumps(ret, **opts), mimetype='application/json; charset=utf-8')
        return wraps(fun)(new)
    return wrapper


def x_real_ip(fun):
    def new(request, *args, **kwargs):
        if 'HTTP_X_REAL_IP' in request.META:
            request.META['REMOTE_ADDR'] = request.META['HTTP_X_REAL_IP']
        return fun(request, *args, **kwargs)
    return wraps(fun)(new)


def on_exception(exc_type, callback):
    def wrapper(fun):
        def new(*args, **kwargs):
            try:
                res = fun(*args, **kwargs)
            except exc_type, e:
                res = callback(e)
            return res
        return wraps(fun)(new)
    return wrapper


def user_has_permissions(strict=False):
    def wrapper(fun):
        def new(request, *args, **kwargs):
            if LOCAL_ENVIRONMENT:
                userinfo = {'has_permissions': True, 'username': 'irlab_local', 'authenticated': True}
            elif request.user.is_authenticated():
                userinfo = {'has_permissions': False, 'username': request.user.username, 'authenticated': True}
                if bool(request.user.groups.filter(name__in=['admin', 'editors'])) | request.user.is_superuser:
                    userinfo['has_permissions'] = True
            else:
                retpath = urlencode({'retpath': SITE_URL})
                if 'HTTP_REFERER' in request.META:
                    retpath = urlencode({'retpath': request.META['HTTP_REFERER']})
                url = 'https://passport.yandex-team.ru/passport?mode=auth&%s' % retpath
                userinfo = {'has_permissions': False, 'username': None, 'authenticated': False, 'login_url': url}
            if strict and not userinfo['has_permissions']:
                res = {
                    'error': 'You don\'t have permissions for this action. If it is a mistake, please, contact tbird@.',
                    'errno': 2
                }
                return HttpResponse(simplejson.dumps(res), mimetype='application/json; charset=utf-8')
            return fun(request, userinfo)
        return wraps(fun)(new)
    return wrapper

