# coding: utf8

import time
import heapq
import os
from operator import itemgetter
from decorators import render_to, jsonify, user_has_permissions

import yt.wrapper as yt

yt.config['operation_tracker']['ignore_stderr_if_download_failed'] = True

DEFAULT_MAX_IMAGES = 60
DEFAULT_COLUMNS = 3


def get_top(iterable, top, key=lambda x: x, predicate=lambda x: True):
    heap = []
    for elem in iterable:
        if predicate(elem):
            heapq.heappush(heap, (key(elem), elem))
        while len(heap) > top:
            heapq.heappop(heap)
    result = []
    while len(heap):
        result.append(heapq.heappop(heap))
    return map(itemgetter(1), reversed(result))


@user_has_permissions()
@render_to(t='doc_by_doc.html')
def index(request, userinfo):
    yt_client = yt.YtClient(proxy='hahn', token=os.environ['YT_TOKEN'])
    timestamp = time.time()
    table_name = request.GET.get('table_name', 'kpi_y_g')
    recs = yt.read_table('//home/search-functionality/doc_by_doc/competitors/' + table_name, client=yt_client)

    snippet_type = request.GET.get('snippet_type', "integral")
    snippet_type_list = snippet_type.split(',') if snippet_type else []
    columns = int(request.GET.get('columns', DEFAULT_COLUMNS))
    max_images = int(request.GET.get('max_images', DEFAULT_MAX_IMAGES))
    refresh = int(request.GET.get('refresh', 300))

    recs = get_top(
        recs,
        max_images,
        key=lambda x: (x.get('Date') + str(1.0 - x.get('WinRate')), hash(x.get('Query') + str(int(timestamp) / 900))),
        predicate=lambda x: snippet_type_list == [] or x.get('Snippet') in snippet_type_list
    )

    column_recs = [list() for i in range(columns)]
    for i, rec in enumerate(recs):
        column_recs[i % columns].append(rec)

    return {
        'columns': column_recs,
        'width': 100.0 / columns,
        'refresh': refresh,
        'snippet_type' : snippet_type
    }
