import argparse

import subprocess
from django.core.management import setup_environ
import settings

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Serp anatomy load utility')
    parser.add_argument('--platform_name', required=True, help="platform name, e.g. Touch")
    parser.add_argument('--search_name', required=True, help="run name, e.g. GoogleRu_2016.12.20")
    parser.add_argument('--onto_json', required=True, help="path to onto.json")
    parser.add_argument('--media_tgz', required=True, help="path to media.tgz")
    args = parser.parse_args()

    setup_environ(settings)
    subprocess.check_call('tar xzf ' + args.media_tgz, shell=True, cwd=settings.MEDIA_ROOT)

    from main.utils import loadonto, remove_unparsed
    # remove_unparsed()
    loadonto(args.platform_name, args.search_name, args.onto_json)
