#coding: utf8

import time
import datetime
from django.db import models


class Platform(models.Model):
    name = models.CharField(max_length=250)

    class Meta:
        ordering = ['name']

    def __unicode__(self):
        return self.name


class Feature(models.Model):
    name = models.CharField(max_length=250)

    class Meta:
        ordering = ['name']

    def egs(self):
        return ElementsGroup.objects.filter(feature=self)

    def __unicode__(self):
        return self.name


class SearchEngine(models.Model):
    name = models.CharField(max_length=250)

    class Meta:
        ordering = ['name']

    def __unicode__(self):
        return self.name


PARSE_CHOICES = (
    ('too_big', u'Слишком большой блок'),
    ('wrong_glue', u'Ошибочная склейка'),
    ('not_glued', u'Не склеилось с другой фичей'),
    ('else', u'Другое')
)

class ElementsGroup(models.Model):
    name = models.CharField(max_length=250, default='')
    comment = models.TextField(default='')
    queries_count = models.IntegerField(default=0)
    skeleton = models.TextField(default='')
    serp_elements_count = models.IntegerField(default=0)
    parse_error = models.CharField(max_length=100, choices=PARSE_CHOICES, default='')
    error_comment = models.TextField(default='')
    duplicate = models.ForeignKey("ElementsGroup", blank=True, null=True)
    selector = models.CharField(max_length=250, default='')
    created = models.DateTimeField(default=datetime.datetime.now, verbose_name=u'Created')
    updated = models.DateTimeField(verbose_name=u'Updated', blank=True, null=True)
    outdated = models.BooleanField(default=False)
    tags = models.ManyToManyField('Tag', null=True, blank=True, verbose_name=u'Теги')
    platform = models.ForeignKey('Platform')
    feature = models.ForeignKey('Feature', blank=True, null=True)
    search = models.ForeignKey('SearchEngine')

    class Meta:
        ordering = ['-updated']

    def examples(self):
        return Example.objects.filter(elements_group=self)[:2]

    def __unicode__(self):
        return self.name if self.name else 'ElementsGroup %s' % str(self.id)


class SkeletonLevel1(models.Model):
    skeleton_level1 = models.TextField(default='', unique=True)
    feature = models.ForeignKey("Feature", null=True)
    is_tame = models.BooleanField(default=True)

    class Meta:
        ordering = ['skeleton_level1']

    def __unicode__(self):
        return 'SkeletonLevel1 %s' % str(self.id)


class ElementsGroupsSkeletonLevel1(models.Model):
    elementsgroup = models.ForeignKey("ElementsGroup")
    skeleton_level1 = models.ForeignKey("SkeletonLevel1")

    class Meta:
        ordering = ['skeleton_level1']

    def __unicode__(self):
        return u'EGSS{}'.format(self.id)


class Example(models.Model):
    serp_id = models.CharField(max_length=250, default='')
    elements_group = models.ForeignKey("ElementsGroup")
    serp_url_static = models.TextField(default='')
    screenshot_filename = models.TextField(default='')
    screenshot_url_static = models.TextField(default='')
    top = models.IntegerField(default=0)
    width = models.IntegerField(default=0)
    height = models.IntegerField(default=0)
    left = models.IntegerField(default=0)
    query_text = models.CharField(max_length=250, default='')
    element_id = models.CharField(max_length=250, default='')
    created = models.DateTimeField(default=datetime.datetime.now, verbose_name=u'Created')
    visible = models.BooleanField(default=True)

    serp_id
    class Meta:
        ordering = ['elements_group']

    def __unicode__(self):
        return u'Example %s' % (self.id)


class Tag(models.Model):
    name = models.CharField(max_length=250, verbose_name=u"Tag")
    virtual = models.BooleanField(default=False)

    def __unicode__(self):
        return self.name

    class Meta:
        ordering = ['name']

