#coding: utf8

import re
from main.models import *
from django import template, conf
from django.template import Context, loader
from django.utils.safestring import mark_safe


register = template.Library()


regexs = {
    'wiki_link': ur"\(\((.*?)\s+(.*?)\)\)",
    'wiki_staff': ur"кто\:([a-zA-Z0-9\-\.@]+)",
    'wiki_bold': ur"\*\*(.*?)\*\*",
    'wiki_cut': re.compile(ur"<{(.*?)\n(.*?)}>", re.DOTALL),
}


@register.simple_tag
def wiki(text, strip=False):
    if type(text) == bool:
        return text

    if not text:
        return ''

    jing_regex = re.compile(ur"https?://jing\.yandex\-team\.ru/.*?\.png", re.DOTALL)
    for m in re.findall(jing_regex, text):
        text = text.replace(m, '<a href="%s" target="_blank"><img src="%s" style="max-width: 300px; max-height: 200px"></img></a>&nbsp;' % (m, m))

    for regex in regexs:
        for m in re.findall(regexs[regex], text):
            text = globals()[regex](text)

    text = text.replace('\n', '<br />')
    return mark_safe(u'<div class="big-text">%s</div>' % text)


def wiki_link(text):
    m = re.search(regexs['wiki_link'], text)
    return text.replace(m.group(0), '<a href="%s" target="_blank">%s</a>&nbsp;' % (m.group(1), m.group(2)))


def wiki_staff(text):
    m = re.search(regexs['wiki_staff'], text)
    return text.replace(m.group(0), '<a href="https://staff.yandex-team.ru/%s" target="_blank">%s</a>' % (m.group(1), m.group(1)))


def wiki_bold(text):
    m = re.search(regexs['wiki_bold'], text)
    return text.replace(m.group(0), '<b>%s<b>' % m.group(1))


def wiki_cut(text):
    m = re.search(regexs['wiki_cut'], text)
    parsed = '<div class="wiki-cut"><span class="wiki-cut-head">%s</span><span class="wiki-cut-body"><br />%s</span></div>' % (m.group(1), m.group(2))
    return text.replace(text[m.start():m.end()], parsed)


@register.simple_tag
def draw_groups(feature, search, platform):
    egs = ElementsGroup.objects.filter(feature=feature, search=search, platform=platform)
    return loader.get_template('draw_groups.html').render(Context({'egs': egs}))


@register.simple_tag
def draw_features(search, platform):
    features = list(set(ElementsGroup.objects.filter(search=search, platform=platform).values_list('feature', flat=True)))
    features = Feature.objects.filter(id__in=features)
    return loader.get_template('draw_features.html').render(Context({'features': features, 'search': search, 'platform': platform}))



