#coding: utf8

import os
import json
import uuid
import urllib
from main.models import *
from settings import PROJECT_ROOT


def loadonto(platform_name, search_name, source_file):
    onto = json.load(open(source_file, 'r'))
    folder = str(uuid.uuid4())
    system_folder = PROJECT_ROOT + '../media/' + folder
    os.makedirs(system_folder)

    for p in [platform_name]:
        platform, created = Platform.objects.get_or_create(name=p)

    for s in [search_name]:
        search, created = SearchEngine.objects.get_or_create(name=s)

    desktop = Platform.objects.get(name=platform_name)
    search = SearchEngine.objects.get(name=search_name)
    for group in onto['groups']:
        opts = {
            'skeleton': group['skeleton'],
            'platform': desktop,
            'search': search
        }
        eg, created = ElementsGroup.objects.get_or_create(**opts)
        eg.queries_count = group['queries_count']
        eg.serp_elements_count = group['serp_elements_count']
        eg.updated = datetime.datetime.now()
        eg.save()

        ss, created = SkeletonLevel1.objects.get_or_create(**{
            'skeleton_level1': group['short_skeleton']
        })

        if ss.is_tame and ss.feature:
            if ss.feature != eg.feature:
                ss.feature = None
                ss.is_tame = False

        egss, created = ElementsGroupsSkeletonLevel1.objects.get_or_create(**{
                'elementsgroup' : eg,
                'skeleton_level1': ss
        })
        ss.save()
        egss.save()

        for example in group['examples']:
            for k, v in example.items():
                if k in ['top', 'left', 'width', 'height'] and not v:
                    example[k] = 0
                if k in ['serp_url_static', 'screenshot_filename', 'screenshot_url_static']:
                    if not v:
                        example[k] = ''
                    else:
                        # if k in ['serp_url_static', 'screenshot_url_static']:
                        #     filename = '%s.%s' % (str(uuid.uuid4()), v.split('.')[-1])
                        #     urllib.urlretrieve (v, system_folder + '/' + filename)
                        #     example[k] = folder + '/' + filename
                        #     print 'Retrieved', v
                        pass

            example['elements_group'] = eg
            ex, created = Example.objects.get_or_create(**example)
            ex.save()

    return


def remove_unparsed():
    ElementsGroup.objects.filter(feature=None).delete()
    return
