#coding: utf8
import codecs
import os
import re
import time
import json
import datetime
import logging
from main.models import *
from urllib import unquote
from django.db.models import F
from django.db.models import Q
from django.db.models import Count
from django.db.models.loading import get_model
from django.shortcuts import get_object_or_404
from django.views.decorators.gzip import gzip_page
from django.template import RequestContext, Context, loader
from decorators import render_to, jsonify, user_has_permissions
from django.http import HttpResponse, Http404, HttpResponseRedirect
# from main.changelog import generate_sel_description, email_changes
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

from transliterator import Transliterator
import settings

@user_has_permissions()
@render_to(t='index.html')
def index(request, userinfo):
    context = {
        'active_page': 'index',
        'tags': Tag.objects.all(),
        'is_authenticated': request.user.is_authenticated(),
        'userinfo': userinfo,
        'platforms': Platform.objects.all(),
        'searches': SearchEngine.objects.all().order_by('-id'),
    }
    return context

@user_has_permissions()
@render_to(t='level1.html')
def level1(request, userinfo):
    #skeletonl1_id = request.GET.get('id', 0)
    #skeletonl1 = get_object_or_404(SkeletonLevel1, id=skeletonl1_id)
    #features =
#    lev1_skels = SkeletonLevel1.objects.annotate(feature_count=Count('elementsgroupsskeletonlevel1__elementsgroup__feature', distinct=True)).order_by('-feature_count')
    lev1_skel_id = request.GET.get('id', 0)
    lev1_skels = SkeletonLevel1.objects.filter(id=lev1_skel_id).all()

    if lev1_skel_id:
        features = Feature.objects.filter(elementsgroup__elementsgroupsskeletonlevel1__skeleton_level1=lev1_skel_id).distinct()
        context = {
            'lev1_skel_id': lev1_skel_id,
            'skeletons': lev1_skels,
            'features': features
        }
        return context

    lev1_skels = SkeletonLevel1.objects.select_related('elementsgroupsskeletonlevel1_set__elementsgroup__feature').annotate(feature_count=Count('elementsgroupsskeletonlevel1__elementsgroup__feature', distinct=True)).order_by('-feature_count')

#    for skel in lev1_skels:
#        skel.feature = set()
#        for egss in skel.elementsgroupsskeletonlevel1_set.all():
#            if egss.elementsgroup.feature:
#                skel.feature.add(egss.elementsgroup.feature.name)

    context = {
        'lev1_skel_id': None,
        'skeletons': lev1_skels,
        'features': None
    }

    return context

@user_has_permissions()
@render_to(t='feature.html')
def feature(request, userinfo):
    feature_id = request.GET.get('id', 0)
    platform_id = request.GET.get('platform', 0)
    search_id = request.GET.get('search', 0)

    feature = get_object_or_404(Feature, id=feature_id)
    platform = get_object_or_404(Platform, id=platform_id)
    search = get_object_or_404(SearchEngine, id=search_id)

    feature_name_razladki = Transliterator().transliterate(feature.name)
    razladki_url = 'https://razladki.yandex-team.ru/serp_anatomy#ts_from=1475308103000&isnow=1&param=goog_{feature_name_razladki}_yandex_coverage&param=goog_{feature_name_razladki}_beast_coverage'.format(feature_name_razladki=feature_name_razladki)

    egs = ElementsGroup.objects.filter(feature=feature, platform=platform, search=search)
    for eg in egs:
        eg.all_examples = Example.objects.filter(elements_group=eg)
    context = {
        'userinfo': userinfo,
        'feature': feature,
        'egs': egs,
        'razladki_url': razladki_url
    }
    return context


@user_has_permissions()
@render_to(t='eg.html')
def elementsgroups(request, userinfo):
    eg_parents = set(ElementsGroupsSkeletonLevel1.objects.values_list('elementsgroup_id', flat=True))
    eg_marked_parents = set(ElementsGroup.objects.filter(elementsgroupsskeletonlevel1__skeleton_level1__feature=F('feature')).values_list('id', flat=True))
    queries_min = request.GET.get('queries_min', 1)

    context = {
        'is_authenticated': request.user.is_authenticated(),
        'userinfo': userinfo,
        'errors': PARSE_CHOICES,
        'eg_parents' : eg_parents,
        'eg_marked_parents' : eg_marked_parents,
        'active_page': 'egs'
    }

    eg_id = request.GET.get('eg_id', 0)
    if eg_id:
        egs = ElementsGroup.objects.filter(id=eg_id)
        context.update({
            'egs_main': egs,
            'show': 'one_group'
        })

        egss = None
        platform = None
        search = None
        features = None
        egs_not_marked = None

        for eg in egs:
                platform = eg.platform
                search = eg.search
                egsss = ElementsGroupsSkeletonLevel1.objects.filter(
                        elementsgroup=eg).select_related('skeleton_level1')
                for egss_element in egsss:
                        egss = egss_element
                        break
                break
        if egss:
                features =  Feature.objects.filter(elementsgroup__elementsgroupsskeletonlevel1__skeleton_level1=egss.skeleton_level1).distinct()
                egs_not_marked = ElementsGroup.objects.filter(elementsgroupsskeletonlevel1__skeleton_level1=egss.skeleton_level1, feature__isnull=True)
        context.update({
            'egs': egs_not_marked,
            'egss': egss,
            'features' : features,
            'platform' : platform,
            'search' : search
        })
        return context

    show = request.GET.get('show', 'unclassified')
    egs = ElementsGroup.objects.filter(queries_count__gte=queries_min)

    if show == 'errors':
        egs = egs.exclude(parse_error__exact="")
    if show == 'unclassified':
        egs = egs.filter(feature__isnull=True, parse_error__exact="")

    paginator = Paginator(egs.order_by('skeleton'), 10)
    page = request.GET.get('page')
    try:
        res = paginator.page(page)
    except PageNotAnInteger:
        res = paginator.page(1)
    except EmptyPage:
        res = paginator.page(paginator.num_pages)

    context.update({
        'egs_main': res,
        'show': show,
        'unclassified_count': egs.count(),
        'all_count': ElementsGroup.objects.all().count(),
        'errors_count': egs.exclude(parse_error__exact="").count(),
        'current_page': int(page) if page else 1
    })
    return context


@jsonify()
def list_features(request):
    return [f.name for f in Feature.objects.all()]


@user_has_permissions()
@jsonify()
def save_eg(request, userinfo):
    eg_id = int(request.POST.get('egId', 0))
    feature_name = request.POST.get('featureName', '').strip()
    group_name = request.POST.get('groupName', '').strip()
    parse_error = request.POST.get('parseError', '').strip()
    error_comment = request.POST.get('errorComment', '').strip()

    if not eg_id:
        return {'error': 'No elementsgroups id'}

    eg = get_object_or_404(ElementsGroup, id=eg_id)
    eg.name = group_name
    eg.error_comment = error_comment
    if feature_name:
        feature, created = Feature.objects.get_or_create(name=feature_name)
        eg.feature = feature

    eg.parse_error = parse_error
    eg.updated = datetime.datetime.now()
    eg.save()

    return {'success': 1, 'egId': eg.id}


@user_has_permissions()
@jsonify()
def save_eg_all(request, userinfo):
    logger = logging.getLogger(__name__)
    logger.error('in save_eg_all')

    eg_id = int(request.POST.get('egId', 0))
    feature_name = request.POST.get('featureName', '').strip()

    if not eg_id:
        return {'error': 'No elementsgroups id'}

    eg = get_object_or_404(ElementsGroup, id=eg_id)

    if feature_name:
        feature, created = Feature.objects.get_or_create(name=feature_name)
        eg.feature = feature

        skeletons_level1 = SkeletonLevel1.objects.filter(elementsgroupsskeletonlevel1__elementsgroup=eg)
        for skeleton_level1 in skeletons_level1:
            skeleton_level1.feature = feature
            skeleton_level1.save()
            egs_not_marked = ElementsGroup.objects.filter(
                elementsgroupsskeletonlevel1__skeleton_level1=skeleton_level1, feature__isnull=True)
            for eg in egs_not_marked:
                eg.feature = feature
                eg.save()

    return {'success': 1, 'egId': eg.id}


# @user_has_permissions()
@render_to(t='report.html')
def report(request, report_name):
    report_name_path = os.path.join(settings.MEDIA_ROOT, report_name + '.json')
    if not os.path.exists(report_name_path):
        return Http404('can not find ' + report_name + '.json')

    feat_id = int(request.GET.get('feat_subtype', 0))
    expand = bool(int(request.GET.get('expand', 1)))

    def find_feat_recursive(root, feat_id):
        if root['id'] == feat_id:
            return root
        for f in root['subfeatures']:
            v = find_feat_recursive(f, feat_id)
            if v:
                return v

    def find_all(root):
        for f in root['subfeatures']:
            yield f
            for subf in find_all(f):
                yield subf

    with codecs.open(report_name_path, encoding='utf8') as f:
        report_root = json.load(f)
    feat_root = find_feat_recursive(report_root['features'], feat_id)
    if not feat_root:
        return Http404('can not find feature with id=%d' % feat_id)

    all_feats = find_all(feat_root)
    all_feats = sorted(all_feats, key=lambda f: (-f['coverage_yandex'], f['name']))

    if expand:
        feat_root['subfeatures'] = all_feats

    if feat_id == 0:
        if expand:
            title = u'Все элементы гугла'
        else:
            title = u'Все элементы гугла, верхний уровень'
    else:
        title = u'Блоки типа ' + feat_root['name']

    context = {
        'title': title,
        'feat_root': feat_root,
        'active_page': 'report_201909',
        'expand': expand,
        'all_feats_count': len(all_feats),
    }
    return context
