import argparse
import logging

import yt.wrapper as yt
from quality.functionality.snippets.yql_lib import YqlClient, YqlOperation, YqlOperationsRunner
from quality.functionality.snippets.utils import configure_logging

QUERY_TEMPLATE = '''\
insert into `{dst}` with truncate
select query
from `{src}`
where
    {filter}
order by Random(query)
limit {count};
'''

BASE_FILTER = 'service == "www.yandex" and locale == "ru"'


def format_script(src, dst_dir, viewer, custom_filter, count):
    dst = dst_dir.rstrip('/') + '/' + viewer
    custom_filter = custom_filter.strip()
    custom_filter = BASE_FILTER + ' and ' + custom_filter if custom_filter else BASE_FILTER
    script = QUERY_TEMPLATE.format(src=src, dst=dst, filter=custom_filter, count=count)
    return script


def main():
    argparser = argparse.ArgumentParser()
    configure_logging(argparser=argparser)
    argparser.add_argument('--log-table', required=True)
    argparser.add_argument('--dst-dir', required=True)
    argparser.add_argument('--viewers', action='append', default=[], required=True)
    argparser.add_argument('--filters', action='append', default=[], required=True)
    argparser.add_argument('--count', type=int, required=True)
    args = argparser.parse_args()

    curretnt_ts = int(args.log_table.rstrip('/').rsplit('/', 1)[1])
    try:
        last_ts = int(yt.get(args.dst_dir.rstrip('/') + '/@last_ts'))
    except Exception:
        last_ts = 0

    if curretnt_ts <= last_ts:
        logging.info('curretnt_ts ({}) <= last_ts ({})'.format(curretnt_ts, last_ts))
        exit(0)

    scripts = []
    for viewer, custom_filter in zip(args.viewers, args.filters):
        scripts.append(format_script(args.log_table, args.dst_dir, viewer, custom_filter, args.count))
    YqlOperationsRunner(yql_client=YqlClient(db='hahn')).run(YqlOperation('\n'.join(scripts)))

    yt.set(args.dst_dir.rstrip('/') + '/@last_ts', curretnt_ts)


if __name__ == '__main__':
    main()
