from django.db import models


class Query(models.Model):
    viewer = models.CharField(max_length=100)
    index = models.IntegerField()
    query = models.TextField()

    def __unicode__(self):
        return u'Query<viewer={}, query={}>'.format(self.viewer, self.query)

    class Meta:
        ordering = ['index']


class Status(models.Model):
    viewer = models.CharField(max_length=100)
    modification_time = models.CharField(max_length=50)
    offset = models.IntegerField()

    def __unicode__(self):
        return u'Status<viewer={}, created={}, offset={}>'.format(self.viewer, self.modification_time, self.offset)
