var allFeatures = [];

function drawError(egId, error_text){
    $('tr[eg-id~="' + egId + '"]').find('.error-div').text(error_text);
}

function onError(text){
    console.log(text);
}

function updateFeatures(){
    $.get('/list-features/', function(data){
        allFeatures = data;
        $(".typeahead").typeahead('destroy');
        $(".typeahead").typeahead({ source:data });
    },'json');
}

function checkNewfeature($tr){
    $newFeature = $tr.find('.new-feature');
    name = $tr.find('input[rel~="feature-name"]').val().trim();
    (name && allFeatures.indexOf(name) == -1) ? $newFeature.show() : $newFeature.hide();
}

$(function(){
    updateFeatures();

    $('input[rel~="feature-name"]').focusout(function(){
        var $tr = $(this).closest('tr');
        setTimeout(function(){
            checkNewfeature($tr); 
        }, 200)
    });

    $('button[rel~="save-eg"]').click(function(){
        var $tr = $(this).closest('tr');
        var data = {
            egId: $tr.attr('eg-id'),
            featureName: $tr.find('input[rel~="feature-name"]').val(),
            groupName: $tr.find('input[rel~="group-name"]').val(),
            parseError: $tr.find('select[rel~="parse-error"]').find(":selected").val(),
            errorComment: $tr.find('textarea[rel~="error-comment"]').val()
        }

        $.ajax({
            url:'/save-eg/',
            type: "POST",
            data: data,
            success: function(data){
                if (data.error){
                    if (data.egId) {
                        drawError(data.egId, data.error);
                        return;
                    }
                    onError(data.error);
                    return
                }
                $tr = $('tr[eg-id~="' + data.egId + '"]');
                $tr.css('background-color', '#E8FFE8');
                updateFeatures();
            },
            error: onError
        });
    });

    $('button[rel~="save-all-eg"]').click(function(){
        var $tr = $(this).closest('tr');
        var data = {
            featureName: $tr.find('input[rel~="feature-name"]').val(),
            egId: $tr.attr('eg-id')
        }

        $.ajax({
            url:'/save-eg-all/',
            type: "POST",
            data: data,
            success: function(data){
                if (data.error){
                    if (data.egId) {
                        drawError(data.egId, data.error);
                        return;
                    }
                    onError(data.error);
                    return
                }
                $tr = $('tr[eg-id~="' + data.egId + '"]');
                $tr.css('background-color', '#E8FFE8');
                updateFeatures();
            },
            error: onError
        });
    });
});
