from django.conf.urls.defaults import patterns, include, url

# Uncomment the next two lines to enable the admin:
from django.contrib import admin
from django.conf.urls.static import static
import settings

admin.autodiscover()

urlpatterns = patterns(
    '',
    url(r'^$', 'main.views.index', name='index'),
    url(r'^egs/$', 'main.views.elementsgroups', name='elementsgroups'),
    url(r'^level1/$', 'main.views.level1', name='hierarchy_level_1'),
    url(r'^feature/$', 'main.views.feature', name='feature'),
    url(r'^list-features/$', 'main.views.list_features', name='list_features'),
    url(r'^save-eg/$', 'main.views.save_eg', name='save_eg'),
    url(r'^save-eg-all/$', 'main.views.save_eg_all', name='save_eg_all'),
    url(r'^report/(?P<report_name>.*?)/$', 'main.views.report', name='report'),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^dbf/', 'main.export.db_file', name='db_file'),
    url(r'^wizard_ban_dashboard/$', 'wizard_ban_dashboard.views.index', name='wizard_ban_dashboard'),
    url(r'^queries_viewer/$', 'queries_viewer.views.index', name='queries_viewer'),
    url(r'^featured_snippet/$', 'featured_snippet.views.index', name='featured_snippet'),
    url(r'^uzhas/$', 'uzhas.views.index', name='uzhas'),
    url(r'^doc_by_doc/$', 'doc_by_doc.views.index', name='doc_by_doc')
)

if settings.LOCAL_ENVIRONMENT:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static('/templates/', document_root=settings.PROJECT_ROOT + 'templates')
    urlpatterns += static('/media/', document_root=settings.MEDIA_ROOT)
