# coding: utf8

import time
import heapq
import os
from operator import itemgetter
from decorators import render_to, jsonify, user_has_permissions

import yt.wrapper as yt

yt.config['operation_tracker']['ignore_stderr_if_download_failed'] = True

DEFAULT_MAX_IMAGES = 60
DEFAULT_COLUMNS = 6


def get_top(iterable, top, key=lambda x: x, predicate=lambda x: True):
    heap = []
    for elem in iterable:
        if predicate(elem):
            heapq.heappush(heap, (key(elem), elem))
        while len(heap) > top:
            heapq.heappop(heap)
    result = []
    while len(heap):
        result.append(heapq.heappop(heap))
    return map(itemgetter(1), reversed(result))


@user_has_permissions()
@render_to(t='wizards_ban.html')
def index(request, userinfo):
    yt_client = yt.YtClient(proxy='hahn', token=os.environ['YT_TOKEN'])
    timestamp = time.time()
    table_name = request.GET.get('table_name', 'wizards_bans')
    recs = yt.read_table('//home/search-functionality/wizards_bans/' + table_name, client=yt_client)

    wizard_type = request.GET.get('wizard_type')
    wizard_type_list = wizard_type.split(',') if wizard_type else []
    columns = int(request.GET.get('columns', DEFAULT_COLUMNS))
    max_images = int(request.GET.get('max_images', DEFAULT_MAX_IMAGES))
    refresh = int(request.GET.get('refresh', 300))

    recs = get_top(
        recs,
        max_images,
        key=lambda x: (x.get('Date'), hash(x.get('Query') + str(int(timestamp) / 900))),
        predicate=lambda x: wizard_type_list == [] or x.get('Wizard') in wizard_type_list
    )

    column_recs = [list() for i in range(columns)]
    for i, rec in enumerate(recs):
        column_recs[i % columns].append(rec)

    return {
        'columns': column_recs,
        'width': 100.0 / columns,
        'refresh': refresh,
    }
