var system = require('system'),
    args = system.args,
    webpage = require('webpage');

if (args.length < 7) {
    console.log('Not all args supported, need: url, filenamePrefix, viewportSize (1280;90), userAgent, selector, captureFeature (0 or 1)');
    phantom.exit(0);
} 

var url = args[1],
    filenamePrefix = args[2],
    viewportSize = args[3].split(';'),
    userAgent = args[4],
    selector = args[5],
    captureFeature = args[6],
    skipRender = true,
    featureRectList = null,
    maxRectCaptured = 100;

page = webpage.create();
page.settings.resourceTimeout = 3000;
page.settings.userAgent = userAgent;
page.viewportSize = {
    width: viewportSize[0],
    height: viewportSize[1]
};

page.onError = function(msg, trace) {
    var msgStack = ['ERROR: ' + msg];
    if (trace && trace.length) {
        msgStack.push('TRACE:');
        trace.forEach(function(t) {
            msgStack.push(' -> ' + t.file + ': ' + t.line + (t.function ? ' (in function "' + t.function + '")' : ''));
        });
    }
    // uncomment to log into the console 
    //console.error(msgStack.join('\n'));
};

function waitFor(testFx, onReady, timeOutMillis) {
    var maxtimeOutMillis = timeOutMillis ? timeOutMillis : 3000, //< Default Max Timout is 3s
        start = new Date().getTime(),
        condition = false,
        interval = setInterval(function() {
            if ( (new Date().getTime() - start < maxtimeOutMillis) && !condition ) {
                // If not time-out yet and condition not yet fulfilled
                condition = (typeof(testFx) === "string" ? eval(testFx) : testFx()); //< defensive code
                if (condition != -1) {
                    skipRender = false;
                    featureRectList = condition;
                }
                //console.log('Condition: ' + condition);
                //console.log('testFx: ' + testFx);
            } else {
                if(!condition) {
                    // If condition still not fulfilled (timeout but condition is 'false')
                    console.log("'waitFor()' timeout");
                    phantom.exit(1);
                } else {
                    // Condition fulfilled (timeout and/or condition is 'true')
                    //console.log("'waitFor()' finished in " + (new Date().getTime() - start) + "ms.");
                    typeof(onReady) === "string" ? eval(onReady) : onReady(); //< Do what it's supposed to do once the condition is fulfilled
                    clearInterval(interval); //< Stop this interval
                }
            }
        }, 400); //< repeat check every N ms
};

page.onResourceError = function(resourceError) {
    page.reason = resourceError.errorString;
    page.reason_url = resourceError.url;
};

page.open(url, function (status) {
    if (status !== "success") {
        console.log(status);
        console.log(url);
        console.log("Unable to access network");
        console.log(
                "Error opening url \"" + page.reason_url
                + "\": " + page.reason
            );
        phantom.exit();
    } else {
        waitFor(function() {
            return page.evaluate(function(selector) {
                if (document.readyState != "complete") return 0;

                if (selector && !document.querySelector(selector)) return -1;
                //return document.querySelector(selector).getBoundingClientRect();
                var ret = [];
                var allElements = document.querySelectorAll(selector);
                for (var i = 0; i < allElements.length; i++) {
                    var element = allElements[i];
                    var rect = element.getBoundingClientRect();
                    seanid = element.getAttribute('seanid');
                    if (!seanid) {
                        seanid = '';
                    }
                    rect.seanid = seanid;
                    ret.push(rect);
                }
                return ret;
            }, selector);

        }, function() {
           setTimeout(function(){
                if (!skipRender) {
                    console.log("found " + featureRectList.length + " elements")
                    for (var i = 0; i < featureRectList.length && i < maxRectCaptured; i++) {
                        var rect = featureRectList[i];
                        if (captureFeature == '1'){
                            page.clipRect = {
                                top:    rect.top,
                                left:   rect.left,
                                width:  rect.width,
                                height: rect.height
                            };
                        }
                        var fileName = filenamePrefix + "_" + i + "_" + rect.seanid + '_' + rect.top + '_' + rect.left + '_' + rect.width + '_' + rect.height + '.png';
                        page.render(fileName);
                        console.log('Screenshot done for ' + url + ' -> ' + fileName);
                    }
                } else {
                    console.log('Skipped for ' + url);
                }
                phantom.exit();
            }, 200);
        });        
    }
});