import argparse

from SerpParser import SerpParser
from settings import GoogleSerpSettingsTouchShort


def process_file(input_fname, out_fname):
    # serp_settings = GoogleSerpSettingsTouch()
    serp_settings = GoogleSerpSettingsTouchShort()
    serp_settings.HTM_SERP_ELEMENTS_SKIP_IF_QUERIES_LE = -1
    serp_short_settings = GoogleSerpSettingsTouchShort()
    serp_parser = SerpParser(serp_settings, serp_short_settings)
    # screenshotter = Screenshotter(phantomjs_path=None, skip_screenshots=True)

    print ">>", input_fname
    with open(input_fname) as f:
        html = f.read()
    serp = serp_parser.parse_serp(html)

    with open(out_fname, 'wb') as fo:
        fo.write(serp.html_with_seanid)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', metavar='input_file', dest='input_file')
    args = parser.parse_args()

    process_file(args.input_file, args.input_file + '.parsed.html')
