# coding=utf-8
import re

class Transliterator:
    TRANSCRIPT_TABLE = u'аa,бb,вv,гg,дd,еe,ёo,жzh,зz,иi,йy,кk,лl,мm,нn,оo,пp,рr,сs,тt,уu,фf,хh,цc,чch,шsh,щsch,ъ,ыi,ь,эe,юyu,яya'
    TRANSCRIPT_DICT = dict()

    def __init__(self):
        self._transcript_dict = self._init_transcript_dict()

    def _init_transcript_dict(self):
        d = dict()
        for item in self.TRANSCRIPT_TABLE.split(','):
            key = item[0]
            value = item[1:]
            d[key] = value
        return d

    def transliterate(self, s):
        if isinstance(s, str):
            s = s.decode('utf8')
        retlist = []
        transcript_dict = self._transcript_dict
        for c in s.lower():
            if 'a' <= c <= u'z' or u'0' <= c <= u'9':
                retlist.append(c)
            else:
                retlist.append(transcript_dict.get(c, '_'))
        ret = ''.join(retlist)
        ret = re.sub(r'_+', '_', ret)
        return ret
