#!/usr/bin/env python

import sqlite3
import sys
import os
from SerpParser import SerpParser
from settings import GoogleSerpSettingsTouchShort
from settings import GoogleSerpSettingsTouch


def update(db_path, html_path):
    gsst = GoogleSerpSettingsTouch()
    gssts = GoogleSerpSettingsTouchShort()
    parser = SerpParser(gsst, gssts)
    conn = sqlite3.connect(db_path)
    cursor = conn.cursor()
    cursor.execute('SELECT id, elements_group_id, serp_url_static, element_id FROM main_example')
    ss_map = {}
    last_ex_map = {}
    bad_eg_id = set()
    counter = 0

    for ex_id, eg_id, url, seanid in cursor.fetchall():
        print 'step={}'.format(counter)
        counter += 1

        full_path = os.path.join(html_path, url)
        if os.path.isfile(full_path):
            with open(full_path) as html_file:
                html = html_file.read()
            dom_element = parser.find_element_by_seanid(html, seanid)
            new_ss = parser.short_skeleton_evaluator.eval_skeleton(dom_element)
            if eg_id not in ss_map:
                ss_map[eg_id] = new_ss
                last_ex_map[eg_id] = ex_id
            else:
                if ss_map[eg_id] != new_ss:
                    print 'conflict in {}'.format(eg_id)
                    print ss_map[eg_id]
                    print 'id={}'.format(last_ex_map[eg_id])
                    print 'vs'
                    print new_ss
                    print 'id={}'.format(ex_id)
                    bad_eg_id.add(eg_id)
                    #sys.exit(-1)
        else:
            print 'no such file: {}'.format(full_path)

    ss_id_map = {}

    for ss in sorted(set(ss_map.values())):
        cursor.execute('INSERT INTO main_skeletonlevel1(skeleton_level1, is_tame) VALUES(\'{}\', 1)'.format(ss))
        conn.commit()
#        cursor.execute('SELECT last_insert_rowid()')
#        for ss_id, in cursor.fetchall():
#            ss_id_map[ss] = ss_id
        ss_id_map[ss] = cursor.lastrowid
    for eg_id in ss_map:
        if eg_id not in bad_eg_id:
            ss_id = ss_id_map[ss_map[eg_id]]
            cursor.execute('INSERT INTO main_elementsgroupsskeletonlevel1(elementsgroup_id, skeleton_level1_id) VALUES ({}, {})'.format(eg_id, ss_id))
            conn.commit()

    cursor.execute("""
        SELECT main_skeletonlevel1.id, MIN(main_elementsgroup.feature_id),
            COUNT(DISTINCT main_elementsgroup.feature_id)
        FROM main_elementsgroup, main_elementsgroupsskeletonlevel1,
            main_skeletonlevel1
        WHERE
            main_elementsgroup.id
                =
            main_elementsgroupsskeletonlevel1.elementsgroup_id
            AND
            main_skeletonlevel1.id
                =
            main_elementsgroupsskeletonlevel1.skeleton_level1_id
        GROUP BY main_skeletonlevel1.id
        ORDER BY COUNT(DISTINCT main_elementsgroup.feature_id)
    """)
    for skeleton_id, feature_id, feature_num in cursor.fetchall():
        if feature_num > 0:
            if feature_num == 1:
                cursor.execute('UPDATE main_skeletonlevel1 SET feature_id={} WHERE id={}'.format(feature_id, skeleton_id))
            else:
                cursor.execute('UPDATE main_skeletonlevel1 SET is_tame=0 WHERE id={}'.format(skeleton_id))
    conn.commit()
    conn.close()

if __name__=='__main__':
    db_path = sys.argv[1]
    html_path = sys.argv[2]
    update(db_path, html_path)
