#!/usr/bin/env python

import sys

metrics = []

with open('./abt_metrics', 'r') as f:
    for name in f:
        metrics.append(name.strip())

for line in sys.stdin:
    query, ui, dom, count, ms = line.split('\t')

    ms = dict(x.split('=') for x in ms.strip().split())

    out = []
    for m in metrics:
        if m in ms.keys():
            out.append(ms[m])
        else:
            out.append('')

    print '\t'.join([query, ui, dom, count] + out)
