#!/usr/bin/env python

import sys
import uatraits

detector = uatraits.detector('/usr/share/uatraits/browser.xml')

for line in sys.stdin:
    line = line.strip()
    data = line.split('\t')

    ua = data[-1]
    if ua != 'None':
        ua = detector.detect(ua)
        data.append(ua['BrowserName'])

        if 'BrowserVersion' in ua.keys():
            data.append(ua['BrowserVersion'])
        else:
            data.append(0)

        data.append(ua['OSFamily'])
        if 'OSVersion' in ua.keys():
            data.append(ua['OSVersion'])
        else:
            data.append(0)

        data.append(1 if ua['isMobile'] else 0)

        if 'isTablet' in ua.keys():
            data.append(1 if ua['isTablet'] else 0)
        else:
            data.append(0)

        if 'isTouch' in ua.keys():
            data.append(1 if ua['isTouch'] else 0)
        else:
            data.append(0)

    else:
        data += ['None']*7

    print '\t'.join([str(x) for x in data])
