#!/usr/bin/env python

import nile
from nile import Record, aggregators as na
from qb2.api.v1 import extractors as se, filters as sf

job_name = 'android_app_access'
root_name = '/home/search-research/shining/'+job_name

def main():
    cluster = nile.clusters.Plato().env(
        job_root=root_name,
        date='{2015-08-19..2015-08-21}',
        )

    job = cluster.job(job_name)
    #log = job.table('statbox/access-log.6p/$date')
    log = job.table('statbox/access-log/$date')

    records = log.qb2(
        log='access-log',
        fields=[
            'uid',
            'date',
            'url',
            'cookies',
            'user_agent',
            'os_name',
            se.dictitem('BrowserName', from_='parsed_os').rename('browser_name'),
            se.dictitem('BrowserVersion', from_='parsed_os').rename('browser_version'),
            se.parameter('type').rename('cgi_type'),
            se.parameter('ui').rename('cgi_ui'),
            se.parameter('service').rename('cgi_service'),
            se.parameter('uuid').rename('cgi_uuid'),
            se.parameter('did').rename('cgi_did'),
            se.parameter('lang').rename('cgi_lang'),
            se.parameter('app_id').rename('cgi_app_id'),
            se.parameter('app_version').rename('cgi_app_version'),
            se.parameter('app_platform').rename('cgi_app_platform'),
            se.parameter('clid').rename('cgi_clid'),
            se.parameter('manufacturer').rename('cgi_manufacturer'),
            se.parameter('model').rename('cgi_model'),
            se.parameter('os_version').rename('cgi_os_version'),
            se.parameter('app_version_name').rename('cgi_app_version_name'),
            se.parameter('app_build_number').rename('cgi_app_build_number'),
            se.parameter('app_req_id').rename('cgi_app_req_id'),
            se.custom('handler', lambda x: x.split('?')[0] if '?' in x else x, 'request')
        ],
        filters=[
            sf.equals('status', '200'),
            sf.equals('cgi_app_platform', 'android'),
            sf.equals('cgi_app_id', 'ru.yandex.searchplugin'),
            sf.one_of('handler',{'/jsonproxy', '/searchapp'}),
        ]
    ).put('$job_root/data')
    job.run()

if __name__ == '__main__':
    main()
