#!/usr/bin/env python

import nile
from nile import Record, aggregators as na, filters as nf
from qb2.api.v1 import extractors as se, filters as sf
import argparse
from datetime import datetime
import sys

def parseArguments(argv):
    parser = argparse.ArgumentParser()
    parser.add_argument("--date1", help = "first date of period in YYYYMMDD format")
    parser.add_argument("--date2", help = "last date of period in YYYYMMDD format")
    parser.add_argument('columns', nargs='*', help='list of columns to output')

    args = parser.parse_args()

    if not args.date1 or not args.date2:
        parser.error('Please, specify two dates')

    try:
        args.date1 = datetime.strptime(args.date1, '%Y%m%d')
        args.date2 = datetime.strptime(args.date2, '%Y%m%d')
    except ValueError:
        parser.error('dates format must be YYYYMMDD')

    return args

job_name = 'android_app_access'
root_name = '/home/search-research/shining/'+job_name

def main(args):
    cluster = nile.clusters.Plato().env(
        job_root=root_name,
        )

    job = cluster.job(job_name)
    records = job.table('$job_root/data')

    records_filtered = records.filter(
            nf.custom(lambda x: args.date1 <= datetime.strptime(x, '%Y-%m-%d'), 'date'),
            nf.custom(lambda x: args.date2 >= datetime.strptime(x, '%Y-%m-%d'), 'date'),
            nf.or_(
                nf.equals('cgi_type', 'sites'),
                nf.equals('cgi_type', None),
                )
            )

    out = records_filtered.project(
        *args.columns
        )

    out = out.unique(
        *args.columns
        ).put('$job_root/out')

    job.run()

    for rec in out.read(mode='records'):
        print '\t'.join([str(v) for k,v in rec.deconstruct()])

if __name__ == '__main__':
    args = parseArguments(sys.argv)
    main(args)
