PRAGMA yson.DisableStrict;

$get_device_type = ($useragent) -> {
    $ua = UserAgent::Parse($useragent);
    RETURN CASE
        WHEN ($useragent = 'desktop' OR $useragent = 'touch') THEN $useragent
        WHEN $ua.isMobile THEN 'touch'
        WHEN $ua.isBrowser THEN 'desktop'
        ELSE 'unknown_device_type'
    END;
};

$metrika_service_map = AsDict(
    AsTuple('34479635', 'collections'),
    AsTuple('43739634', 'district'),
    AsTuple('47845414', 'Q'), -- znatoki
    -- AsTuple('34225155', 'theq'),
    AsTuple('722884', 'video'), -- video desktop
    AsTuple('11339902', 'video'), -- video touch
    AsTuple('722818', 'news'),
    AsTuple('51697790', 'ether'),
    AsTuple('46753068', 'ugc'),
    AsTuple('46859772', 'turbo'),
    AsTuple('51357310', 'sport'),
    AsTuple('51446871', 'zen'),
    AsTuple('44812261', 'zen'),
    AsTuple('62437750', 'ugc'),
    AsTuple('62403583', 'ugc'),
);

$social_notification = ($utm_content) -> {RETURN
    $utm_content LIKE '%org_business_answer' OR
    $utm_content LIKE '%_poll_like_count' OR
    $utm_content LIKE '%_like_count' OR
    $utm_content LIKE '%_week_like_count' OR
    $utm_content LIKE '%_review_user_like_more' OR
    $utm_content LIKE '%_review_user_like' OR
    $utm_content LIKE '%org_view_count' OR
    $utm_content LIKE '%org_reviews_views_count' OR
    $utm_content LIKE '%_review_user_comment';
};

$mssngr_tags = ($chat_id, $origin_service) -> {
    $result = AsList('mssngr');
    
    -- namespace source: https://bitbucket.browser.yandex-team.ru/projects/MSSNGR/repos/messenger-backend-history/browse/src/yamb/utils/default.py#573
    $namespace = CASE
        WHEN $chat_id LIKE '0/3/%' THEN AsList('cmnt')
        WHEN $chat_id LIKE '0/6/%' THEN AsList('district')
        WHEN $chat_id LIKE '0/7/%' THEN AsList('ether')
        WHEN $chat_id LIKE '0/9/%' THEN AsList('website_chats')
        WHEN $chat_id LIKE '0/10/%' THEN AsList('collections')
        WHEN $chat_id LIKE '0/13/%' THEN AsList('video','video_chats')
        ELSE ListCreate(String)
    END;
    
    -- origin source: https://a.yandex-team.ru/arc/trunk/arcadia/mssngr/router/lib/protos/message.proto?rev=6203993#L86
    $origin_tag = CASE $origin_service
        WHEN 2 THEN AsList('serp')
        WHEN 3 THEN AsList('district')
        WHEN 4 THEN AsList('ether')
        WHEN 10 THEN AsList('morda')
        WHEN 16 THEN AsList('geo')
        WHEN 18 THEN AsList('collections')
        WHEN 32 THEN AsList('video','video_chats')
        ELSE ListCreate(String)
    END;
    $host = CASE $origin_service
                WHEN 5 THEN AsList('mssngr_ios_searchapp')
                WHEN 6 THEN AsList('mssngr_ios_browser')
                WHEN 7 THEN AsList('mssngr_ios_standalone')
                WHEN 24 THEN AsList('mssngr_android_searchapp')
                WHEN 25 THEN AsList('mssngr_android_browser')
                WHEN 26 THEN AsList('mssngr_android_standalone')
                ELSE ListCreate(String)
            END;
    $platform = AsList(IF (($origin_service ?? 0) IN (5,6,7), 'mssngr_ios',
    IF(($origin_service ?? 0) IN (17,24,25,26), 'mssngr_android',
    'mssngr_web')));
    RETURN ListExtend($result, $namespace, $origin_tag, $host, $platform)
};

$iznanka_read_more_tags = ($referer, $useragent, $params) -> {
    $dt = $get_device_type($useragent);
    $app_id = Url::GetCGIParam($referer,'app_id');
    RETURN
    CASE 
        WHEN $app_id =='iznanka' THEN 'iznanka_browser'
            --CASE  WHEN $dt =='touch' THEN 'iznanka_browser_android' ELSE 'iznanka_browser_desktop' END
        ELSE 
            CASE WHEN Yson::LookupBool(Yson::ParseJson($params), 'isStrangerPk') THEN 'epp' ELSE 'lk' END
    END;
};

$translate_push_service = ($project, $push_type) -> {
    RETURN CASE
        WHEN $project = 'podb' THEN 'collections'
        WHEN $project = 'stream' AND $push_type LIKE 'video%sociality%' THEN 'video'
        WHEN $project = 'serp' THEN 'xxx'
        WHEN $project = 'cmnt' AND $push_type LIKE 'cmnt.%.news' THEN 'news'
        WHEN $project = 'cmnt' AND $push_type LIKE 'cmnt.%.socialserp' THEN 'socialserp'
        WHEN $project = 'cmnt' AND $push_type LIKE 'cmnt.%.turbo' THEN 'turbo'
        WHEN $project = 'cmnt' AND $push_type LIKE 'cmnt.%.sport' THEN 'sport'
        WHEN ($project = 'cmnt' AND $push_type LIKE 'cmnt.%.ether') OR
            ($project = 'stream' AND $push_type LIKE 'tv_online%sociality%') THEN 'ether'
        ELSE $project
    END;
};

$notifier_filter = ($project, $notif_type) -> {
    RETURN
        $project = 'district' AND $notif_type NOT LIKE 'default_message%' OR
        $project = 'collections' OR
        $project = 'ugc' AND $social_notification($notif_type) OR
        $project = 'znatoki' OR
        ($project ?? '') IN ('news', 'socialserp', 'turbo', 'sport', 'video', 'ether') AND $notif_type LIKE 'cmnt.%';
};

$push_filter = ($project, $push_type) -> {
    RETURN
        $project = 'district' OR
        $project = 'podb' OR
        $project = 'ugc' AND $social_notification($push_type) OR
        $project = 'znatoki' OR
        $project = 'stream' AND ($push_type LIKE 'tv_online%sociality%' OR $push_type LIKE 'video%sociality%') OR
        $project = 'cmnt' AND (
            $push_type LIKE 'cmnt.%.news' OR
            $push_type LIKE 'cmnt.%.socialserp' OR
            $push_type LIKE 'cmnt.%.turbo' OR
            $push_type LIKE 'cmnt.%.sport' OR
            $push_type LIKE 'cmnt.%.ether');
};

$social = ($service) -> {RETURN ($service ?? '') IN ('district', 'Q');};

$halfsocial = ($service) -> {RETURN ($service ?? '') IN ('collections', 'video', 'news', 'ether', 'ugc', 'zen');};

export $get_device_type, $metrika_service_map, $social_notification,
    $mssngr_tags, $translate_push_service, $notifier_filter, $push_filter,
    $social, $halfsocial, $iznanka_read_more_tags;

