USE hahn;
$month_curr = CurrentUtcDatetime();
$dt = $month_curr - Interval("P1D");

$format_m = DateTime::Format("%Y-%m");
$format = DateTime::Format("%Y-%m-%d");

$script = @@#py
def cumm(q):
    w, s = [], 0
    for k in q:
        s += k
        w.append(s)
    return w
@@;
$callable = Python3::cumm( Callable<(List<UInt64>)->List<Int32>>,  $script);


DEFINE ACTION $creatives_stats($dt) as
$date_end = DateTime::MakeTimestamp(cast($dt as Date));

$a = (
select SUM(available) AS granted, 
    login, month, package_id, 
    $format(min(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at)))) as dd
from ( select
    package_id, login,
    SUM(`count`) AS available, MIN(created_at) as created_at
from hahn.`home/pythia/private/pg_raw/survey_package_topups` as a
LEFT JOIN any `//home/pythia/private/pg_raw/survey_packages` as z ON a.package_id = z.id
LEFT JOIN any `//home/pythia/private/pg_raw/customers` as x ON z.customer_id = x.id
WHERE DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at)) <= $date_end
    and login not in ["ninjagrizzly-test", "Рога и Копыта"] 
    and a.package_id not in [103, 252, 14]
    --and login in ["Материа Медика", "Wargaming", "Черкизово", "Danone", "SEB Group", "Tele 2"]
group by a.package_id as package_id,
    String::Strip(CAST(x.name as STRING)) as login
) group by login, package_id, 
    $format_m(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at))) as month
);


$b = (
SELECT
    COUNT(*) AS used,
    login, package_id, 
    month, dd
FROM hahn.`home/pythia/private/pg_raw/survey_package_surveys` as a 
    INNER JOIN `//home/pythia/private/pg_raw/surveys` as b 
    ON a.survey_id = b.id
LEFT JOIN any `//home/pythia/private/pg_raw/survey_packages` as z ON a.package_id = z.id
LEFT JOIN any `//home/pythia/private/pg_raw/customers` as x ON z.customer_id = x.id
WHERE DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at)) <= $date_end
    and login not in ["ninjagrizzly-test", "Рога и Копыта"] 
    and a.package_id not in [103, 252, 14]
    --and login in ["Материа Медика", "Wargaming", "Черкизово", "Danone", "SEB Group", "Tele 2"]
GROUP BY a.package_id as package_id, 
    String::Strip(CAST(x.name as STRING)) as login,
    $format_m(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at))) as month,
    $format(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at))) as dd
);


$c2 = (
FROM $a as a FULL JOIN $b as b 
    using (login, package_id) -- month, 
SELECT
    a.dd as date_granted,
    b.dd as date_used,
    IF(a.login IS NOT NULL, a.login, b.login) as login,
    a.granted ?? 0 as granted,
    b.used ?? 0 as used, 
    a.package_id as package_id
WHERE a.package_id not in [103, 252, 14]
);


$g = (SELECT login, granted, date_granted, package_id,
    ListZip( $callable(AGGREGATE_LIST(used)), AGGREGATE_LIST(date_used) ) as used_list
    FROM $c2 group by login, granted, date_granted, package_id
    );
$f = (SELECT * FROM $g flatten by used_list);
$m = (SELECT package_id, granted - used_list.0 as tl, used_list.1 as date_used FROM $f);
$n = (SELECT * 
    FROM $c2 as m1 left join $m as m2
    on m1.package_id = m2.package_id and m1.date_used = m2.date_used);

INSERT INTO hahn.`home/goda/rkam/surveys/PYTHIADEV-3427/c_name` WITH TRUNCATE
SELECT n.*, (tl ?? granted - used) as tests_left without tl FROM $n as n;
COMMIT;


$c = select * from $a union all select * from $b;

$zero_today = (SELECT 0 as used, 0 as granted, $format_m($date_end) as month, NULL as login);

--$d = (FROM $c2 
$d = (FROM $c
SELECT month, login,
    SUM(granted) as granted,
    SUM(used) as used
GROUP BY month as month, login
UNION ALL SELECT * FROM $zero_today
);


-- Считаем количество новых клиентов
$new_logins = (
SELECT COUNT(login) as new_logins,
    SUM(granted) as new_login_granted,
    month
FROM (SELECT login,
    MIN_BY(month, month) as month,
    MIN_BY(granted, month) as granted
    FROM $d GROUP BY login)
GROUP BY month
);

-- Считаем использование тестов новыми клиентами
$new_logins_used = (
SELECT SUM(used) as new_login_used,
    COUNT_IF(used IS NOT null and used !=0 ) as active_users_new,
    month
FROM (SELECT login,
    MIN_BY(month, month) as month,
    MIN_BY(used, month) as used
    FROM $d GROUP BY login)
GROUP BY month
);

-- Таблица с активными пользователями и пакетами в разрезе по месяцам
$table = (
FROM $d as d SELECT
    month,
    SUM(granted) as granted,
    SUM(used) as used,
    COUNT(login) as total_logins,
    COUNT_IF(used IS NOT null and used !=0 ) as active_users
GROUP BY d.month as month
);

-- Джойним новых клиентов
$crossjoin = (
    FROM $table as t
    LEFT JOIN ANY $new_logins as nl ON t.month=nl.month
    LEFT JOIN ANY $new_logins_used as nlu ON t.month=nlu.month
SELECT
    UNWRAP(t.month) as month,
    granted ?? 0 as granted,
    used ?? 0 as used,
    total_logins ?? 0 as total_logins,
    active_users ?? 0 as active_users,
    active_users_new ?? 0 as active_users_new,
    (active_users ?? 0) - (active_users_new ?? 0) as active_users_old,
    (total_logins ?? 0) - (nl.new_logins ?? 0) as old_logins,
    new_logins ?? 0 as new_logins,
    new_login_granted ?? 0 as new_login_granted,
    new_login_used ?? 0 as new_login_used,
    (granted ?? 0) - (new_login_granted ?? 0) as old_login_granted,
    (used ?? 0) - (new_login_used ?? 0) as old_login_used
);

$total = (FROM $d 
SELECT
    SUM(granted) as granted,
    SUM(used) as used,
    COUNT(DISTINCT login) as logins,
    COUNT(DISTINCT IF(used IS NOT NULL and used !=0, login, NULL)) as active_logins
);

----- PUBLISH -----

$cr_monthly_cum = (
    SELECT t.*, UNWRAP($format_m($date_end)) as fielddate 
    FROM $total as t); COMMIT;

UPSERT INTO stat.`Pythia/surveys/analytics/creatives_analytics/tests_for_creatives_login_cumm/monthly`
SELECT * FROM $cr_monthly_cum;

$cr_daily_cum = (
    SELECT t.*, UNWRAP($format($date_end)) as fielddate 
    FROM $total as t); COMMIT;

UPSERT INTO stat.`Pythia/surveys/analytics/creatives_analytics/tests_for_creatives_login_cumm/daily`
SELECT * FROM $cr_daily_cum;


$cr_monthly = (
SELECT cj.*, UNWRAP($format_m($date_end)) as fielddate, WITHOUT month
    FROM $crossjoin as cj 
    WHERE month == $format_m($date_end)
    ); COMMIT;

UPSERT INTO stat.`Pythia/surveys/analytics/creatives_analytics/tests_for_creatives_login_monthly/monthly`
SELECT * FROM $cr_monthly;

$cr_daily = (
    SELECT cj.*, UNWRAP($format($date_end)) as fielddate, WITHOUT month
    FROM $crossjoin as cj
    WHERE month == $format_m($date_end)
    ); COMMIT;

UPSERT INTO stat.`Pythia/surveys/analytics/creatives_analytics/tests_for_creatives_login_monthly/daily`
SELECT * FROM $cr_daily;

END DEFINE;


$numdays = 2;
$dates = ListMap(ListFromRange(1, $numdays), ($d) -> { RETURN CurrentUtcDate() - $d * Interval('P1D');  });
EVALUATE FOR $i IN $dates
    DO $creatives_stats($i);

