USE hahn;
$month_curr = CurrentUtcDatetime();
$dt = $month_curr - Interval("P1D");

$format_m = DateTime::Format("%Y-%m");
$format = DateTime::Format("%Y-%m-%d");

$script = @@#py
def cumm(q):
    w, s = [], 0
    for k in q:
        s += k
        w.append(s)
    return w
@@; -- double @@ are quotes for multiline string literals
$callable = Python3::cumm( Callable<(List<UInt64>)->List<Int32>>,  $script);


DEFINE ACTION $creatives_stats($dt) as
$date_end = DateTime::MakeTimestamp(cast($dt as Date));

$a_week = (  
SELECT dd,
    SUM(count) AS available,
    package_id,
    cast(year as string) || cast(week as string) as year_week
FROM hahn.`home/pythia/private/pg_raw/survey_package_topups`
WHERE DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at)) <= $date_end
GROUP BY package_id,
    $format(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at))) as dd,
    DateTime::GetYear(DateTime::ParseIso8601(created_at)) as year,
    DateTime::GetWeekOfYear(DateTime::ParseIso8601(created_at)) as week
);

$b_week = (
SELECT dd,
    COUNT(*) AS used,
    package_id,
    cast(year as string) || cast(week as string) as year_week
FROM hahn.`home/pythia/private/pg_raw/survey_package_surveys` as a 
    INNER JOIN `//home/pythia/private/pg_raw/surveys` as b 
    ON a.survey_id = b.id
WHERE DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at)) <= $date_end
GROUP BY a.package_id as package_id,
    $format(DateTime::MakeTimestamp(DateTime::ParseIso8601(created_at))) as dd,
    DateTime::GetYear(DateTime::ParseIso8601(created_at)) as year,
    DateTime::GetWeekOfYear(DateTime::ParseIso8601(created_at)) as week
);

-- здесь берем еще и тех, кому не был подарен тест, но кто использовал их (FULL JOIN)
$c_week = (
FROM $a_week as a FULL JOIN $b_week as b 
    ON a.package_id = b.package_id and a.year_week = b.year_week
SELECT IF(a.year_week IS NOT NULL, a.year_week, b.year_week) as year_week,
    a.dd as date_granted,
    b.dd as date_used,
    IF(a.package_id IS NOT NULL, a.package_id, b.package_id) as package_id,
    a.available as granted,
    b.used as used
WHERE a.package_id NOT IN [103, 252, 14]
);

$c2_week = (FROM $c_week as a
    LEFT JOIN any `//home/pythia/private/pg_raw/survey_packages` as z ON a.package_id = z.id
    LEFT JOIN any `//home/pythia/private/pg_raw/customers` as x ON z.customer_id = x.id
SELECT login,
    year_week,
    SUM(granted) ?? 0 as granted,
    SUM(used) ?? 0 as used
WHERE String::Strip(CAST(x.name as STRING)) not in ["ninjagrizzly-test", "Рога и Копыта"]
GROUP BY a.year_week as year_week,
    String::Strip(CAST(x.name as STRING)) as login
);

$zero_week = (SELECT 
    0 as used, 0 as granted,
    cast(DateTime::GetYear($date_end) as string) || cast(DateTime::GetWeekOfYear($date_end) as string) 
 as year_week,
    NULL as login
);

$d_week = (FROM $c2_week SELECT year_week, login,
    SUM(granted) as granted,
    SUM(used) as used
GROUP BY year_week, login
UNION ALL SELECT * FROM $zero_week
);

-- Считаем количество новых клиентов
$new_logins_week = (
SELECT COUNT(login) as new_logins,
    SUM(granted) as new_login_granted,
    year_week
FROM (SELECT login,
    MIN_BY(year_week, year_week) as year_week,
    MIN_BY(granted, year_week) as granted
    FROM $d_week GROUP BY login)
GROUP BY year_week
);

-- Считаем использование тестов новыми клиентами
$new_logins_used_week = (
SELECT SUM(used) as new_login_used,
    COUNT_IF(used IS NOT null and used !=0 ) as active_users_new,
    year_week
FROM (SELECT login,
    MIN_BY(year_week, year_week) as year_week,
    MIN_BY(used, year_week) as used
    FROM $d_week GROUP BY login)
GROUP BY year_week
);

-- Таблица с активными пользователями и пакетами в разрезе по месяцам
$table_week = (
SELECT year_week,
    SUM(granted) as granted,
    SUM(used) as used,
    COUNT(login) as total_logins,
    COUNT_IF(used IS NOT null and used !=0 ) as active_users
FROM $d_week as d
GROUP BY year_week
);

-- Джойним новых клиентов
$crossjoin_week = (
    FROM $table_week as t
    LEFT JOIN ANY $new_logins_week as nl ON t.year_week=nl.year_week
    LEFT JOIN ANY $new_logins_used_week as nlu ON t.year_week=nlu.year_week
SELECT
    t.year_week as year_week,
    granted ?? 0 as granted,
    used ?? 0 as used,
    total_logins ?? 0 as total_logins,
    active_users ?? 0 as active_users,
    active_users_new ?? 0 as active_users_new,
    (active_users ?? 0) - (active_users_new ?? 0) as active_users_old,
    (total_logins ?? 0) - (nl.new_logins ?? 0) as old_logins,
    new_logins ?? 0 as new_logins,
    new_login_granted ?? 0 as new_login_granted,
    new_login_used ?? 0 as new_login_used,
    (granted ?? 0) - (new_login_granted ?? 0) as old_login_granted,
    (used ?? 0) - (new_login_used ?? 0) as old_login_used
);

----- PUBLISH -----

$cr_weekly = (
    SELECT cj.*, 
    UNWRAP($format(DateTime::StartOfWeek($date_end))) as fielddate
    without year_week
    FROM $crossjoin_week as cj
    WHERE year_week == cast(DateTime::GetYear($date_end) as string) || cast(DateTime::GetWeekOfYear($date_end) as string)
    );
COMMIT;

UPSERT INTO stat.`Pythia/surveys/analytics/creatives_analytics/tests_for_creatives_login_monthly/weekly`
SELECT * FROM $cr_weekly;

END DEFINE;


$numdays = 2;
$dates = ListMap(ListFromRange(1, $numdays), ($d) -> { RETURN CurrentUtcDate() - $d * Interval('P1D');  });
EVALUATE FOR $i IN $dates
    DO $creatives_stats($i);

