USE hahn;
PRAGMA yt.StaticPool = "goda-other";
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

$format = DateTime::Format("%Y-%m-%d");
$day = CurrentUtcDate();--  - Interval("P1D")
$end_date = CAST(($day - Interval("P1D")) as Date);
$start_date = CAST(($day - 90*Interval("P1D")) as Date);

$raw_data2 = (
    SELECT tiburon_resp_id, COUNT(DISTINCT slug) as cnt FROM `//home/pythia/export/prod/survey_interviews`
    WHERE Yson::Contains(query, 'xrid') AND finished_at >= $start_date AND finished_at <= $end_date AND Yson::LookupString(raw_data, 'supplier_id') == "tiburon" AND is_finished 
    GROUP BY Yson::LookupString(query, 'xrid') as tiburon_resp_id
);

UPSERT INTO stat.`Pythia/surveys/analytics/tiburon_id_stats/daily`

SELECT UNWRAP($format($end_date)) as fielddate,
    PERCENTILE(cnt, 0.25) as q25,
    PERCENTILE(cnt, 0.50) as q50,
    PERCENTILE(cnt, 0.75) as q75,
    PERCENTILE(cnt, 0.90) as q90,
    PERCENTILE(cnt, 0.95) as q95,
    PERCENTILE(cnt, 0.98) as q98,
    MAX(cnt) as q100
FROM $raw_data2


