-- https://yql.yandex-team.ru/Operations/YTXuYRJKfVebkywa93SbNByaA52mebeG3KFdpPEkL6Q=
$day = CurrentUtcDate();
$end_date = CAST($day - 1*Interval("P1D") as Date);
$start_date = CAST($day - 30*Interval("P1D") as Date);
$format = DateTime::Format("%Y-%m-%d");


DEFINE SUBQUERY $md($r) AS
    SELECT t.*, IF(is_multiple_choice == true, "multiple_choice", question_type) as question_type2, WITHOUT t.question_type
    FROM hahn.`home/goda/burdanov/surveys/pythia_answers` as t
    WHERE IF($r == "question", question_timestamp IS NOT NULL, answer_timestamp IS NOT NULL) AND CAST(DateTime::FromMicroseconds(question_timestamp) as Date) >= $start_date AND CAST(DateTime::FromMicroseconds(question_timestamp) as Date) <= $end_date
END DEFINE;


DEFINE SUBQUERY $calc_stats_with_totals($sppl, $qtp, $rttn, $q_or_a) AS
    FROM $md($q_or_a)
    SELECT
        UNWRAP($format(MAX(CAST(DateTime::FromMicroseconds(question_timestamp) AS date)))) AS fielddate,
        COUNT(DISTINCT interview_id) as interviews,--COUNT(DISTINCT yandexuid) as yandexuids,
        COUNT(DISTINCT survey_id) as surveys,
        COUNT(*) as hits,
        UNWRAP(question_type) as question_type, supplier_id, has_rotation
    GROUP BY
        $format(CAST(DateTime::FromMicroseconds(question_timestamp) AS date)) AS fielddate,
        IF($sppl == 1, supplier_id ?? "not_specified", "_total_") as supplier_id,
        IF($qtp == 1, question_type2, "_total_") as question_type,
        IF($rttn == 1, CAST(has_rotation AS STRING) ?? "false", "_total_") as has_rotation
END DEFINE;


DEFINE SUBQUERY $calc_stats_fin($g) AS
    SELECT * FROM $calc_stats_with_totals(0, 0, 0, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(1, 0, 0, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(0, 1, 0, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(0, 0, 1, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(1, 0, 1, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(1, 1, 0, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(0, 1, 1, $g)
    UNION ALL
    SELECT * FROM $calc_stats_with_totals(1, 1, 1, $g)
END DEFINE;


UPSERT INTO stat.`Pythia/surveys/analytics/answers_stats2/daily`
SELECT * FROM $calc_stats_fin("answer");

UPSERT INTO stat.`Pythia/surveys/analytics/interviews_stats2/daily`
SELECT * FROM $calc_stats_fin("question");

