use hahn;

declare $yt_pool as String;
declare $date as String;
declare $surveys_path as String;
declare $dst_folder_path as String?;

pragma yt.Pool = $yt_pool;
pragma yt.UseNativeYtTypes = "1";

$dst_folder_path = $dst_folder_path ?? $surveys_path;

$date_from = DateTime::Format("%Y-%m-%d")(cast($date as Date) - Interval("P6D"));
$date_to = $date;

$crypta_data =
select
    TableName() as day,
    yandexuid,
    yandex_loyalty,
    Yson::LookupString(exact_socdem, "age_segment", Yson::Options(false AS Strict)) AS age,
    Yson::LookupString(exact_socdem, "gender", Yson::Options(false AS Strict)) AS gender,
    Yson::LookupString(exact_socdem, "income_5_segment", Yson::Options(false AS Strict)) AS income_5,
    ListSortDesc(DictItems(Yson::ConvertToDoubleDict(age_segments)), ($x) -> ($x.1))[0].1 as prob_age,
    ListSortDesc(DictItems(Yson::ConvertToDoubleDict(gender)), ($x) -> ($x.1))[0].1 as prob_gender,
    ListSortDesc(DictItems(Yson::ConvertToDoubleDict(income_5_segments)), ($x) -> ($x.1))[0].1 as prob_income_5,
from range(`statbox/crypta-yandexuid-profiles-log`, $date_from, $date_to);

$pythia_answers_path = $surveys_path || "/pythia_answers";
$pythia_answers_enrich_path = $surveys_path || "/pythia_answers_enrich";
$dst_pythia_answers_enrich_path = $dst_folder_path || "/pythia_answers_enrich";

insert into $dst_pythia_answers_enrich_path with truncate
select unwrap(day) as day, t.*
without day
from $pythia_answers_enrich_path as t
where day < $date_from
assume order by day, survey_id, interview_id, start_timestamp, question_timestamp, answer_timestamp;

insert into $dst_pythia_answers_enrich_path
select unwrap(a.day) as day, a.*, c.*
without a.day, c.day, c.yandexuid
from $pythia_answers_path as a
left join any $crypta_data as c
using (day, yandexuid)
where a.day >= $date_from
order by day, survey_id, interview_id, start_timestamp, question_timestamp, answer_timestamp;

$zen_answers_path = $surveys_path || "/zen_answers";
$zen_answers_enrich_path = $surveys_path || "/zen_answers_enrich";
$dst_zen_answers_enrich_path = $dst_folder_path || "/zen_answers_enrich";

insert into $dst_zen_answers_enrich_path with truncate
select unwrap(day) as day, t.*
without day
from $zen_answers_enrich_path as t
where day < $date_from
assume order by day, interview_id, question_timestamp, answer_timestamp;

insert into $dst_zen_answers_enrich_path
select unwrap(a.day) as day, a.*, c.*
without a.day, c.day, c.yandexuid
from $zen_answers_path as a
left join any $crypta_data as c
using (day, yandexuid)
where a.day >= $date_from
order by day, interview_id, question_timestamp, answer_timestamp;
