USE `hahn`;
-- YQL Nirvana Operation: https://nirvana.yandex-team.ru/process/ad6bfa51-be6f-43a8-9944-8115d2e80308/graph/operation/c562c467-0bdb-47ee-b85d-7c43cd6b480e
PRAGMA yt.DefaultCluster = "hahn";
PRAGMA yt.InferSchema = '1';
PRAGMA yson.DisableStrict;
PRAGMA yson.AutoConvert;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$day = CurrentUtcDate()- Interval("P1D");
$end_date = CAST($day as DATE);

$input_path = "//logs/news-scarab-surveys-reply/1d/" || CAST($end_date AS String);

$data_shows = (SELECT
    Yandexuid as yandexuid,
    SurveyId as survey_id, 
    IF(Yson::Lookup(Yson::ParseJson(Data), "req_id") IS NULL, 2, 1) as question_id_data,
    DateTime::ToMicroseconds(DateTime::MakeTimestamp(DateTime::ParseIso8601(iso_eventtime))) as question_timestamp,
    Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(Data), "req_id")) as req_id,
    Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(Data), "page_url")) as page_referer,
    FROM $input_path WHERE ScreenId == "show-event"
);

$data_answers = (SELECT 
    Yandexuid as yandexuid,
    SurveyId as survey_id,
    IF(ScreenId LIKE "%%-no%%" OR ScreenId LIKE "%%-yes%%", 2, 1) as question_id_data,
    DateTime::ToMicroseconds(DateTime::MakeTimestamp(DateTime::ParseIso8601(iso_eventtime))) as answer_timestamp,
    Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(Data), "answer_id")) as answer_option_ids,
    DictKeys(Yson::ConvertToDict(Yson::ParseJson(Data)["values"])) as answer_option_labels,
    Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(Data), "req_id")) as answer_req_id,
    Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(Data), "page_url")) as answer_referer
    FROM $input_path WHERE ScreenId != "show-event"
);


$folder = "home/ynews/surveys/config_dumps/ts";
$config_dumps = (SELECT AGG_LIST(Path) FROM FOLDER($folder)); -- берем самую свежую
$config_dumps_last = ListMax($config_dumps);

$flattened_config = (
    SELECT *
        FROM (SELECT 
        CAST(id AS uint64) as SurveyId,
        Yson::ConvertToString(Yson::Lookup(Yson::ParseJson(data), "type")) as ttype,
        Yson::ConvertToList(Yson::Lookup(Yson::ParseJson(data), "screens")) as screens,
        ListLength(Yson::ConvertToList(Yson::Lookup(Yson::ParseJson(data), "screens"))) as count_screens
        FROM $config_dumps_last
    ) FLATTEN BY screens
);

$parse_config = (
    SELECT SurveyId as survey_id,
    Yson::ConvertToString(Yson::Lookup(screens, "title")) as question_label,
    Yson::ConvertToString(Yson::Lookup(screens, "template")) as question_type,
    IF(Yson::ConvertToBool(Yson::Lookup(screens, "root")) == TRUE, 1, IF(Yson::ConvertToBool(Yson::Lookup(screens, "modal")) == TRUE, 2, IF(count_screens == 1, 1, NULL))) as question_id,
    ListFlatMap(Yson::ConvertToList(Yson::Lookup(screens, "answers")), ($x) -> {RETURN $x['id'] }) as question_option_ids,-- ListMap
    ListFlatMap(Yson::ConvertToList(Yson::Lookup(screens, "answers")), ($x) -> {RETURN $x['name'] }) as question_option_labels,
    IF (Yson::ConvertToBool(Yson::Lookup(screens, "randomizeAnswers")) == TRUE, TRUE, FALSE) as has_rotation,
    IF (Yson::ConvertToString(Yson::Lookup(screens, "template")) == "checkboxes", TRUE, NULL) AS is_multiple_choice,
    FROM $flattened_config
);

$parsed_config = (
    SELECT survey_id,
        question_label,
        question_type,
        question_id,
        question_option_ids,
        question_option_labels,
        has_rotation,
        is_multiple_choice,
        IF (question_type == "rate-service", ListMax(ListMap(question_option_ids, ($x) -> { RETURN Yson::ConvertToInt64($x) })), NULL) AS max_value,
        IF (question_type == "rate-service", ListMin(ListMap(question_option_ids, ($x) -> { RETURN Yson::ConvertToInt64($x) })), NULL) AS min_value,
    FROM $parse_config WHERE question_type != "message"
);


$data_join = (
    SELECT * WITHOUT d.question_id_data
    FROM $data_shows as d
    JOIN $parsed_config as c
        ON (d.survey_id == c.survey_id AND d.question_id_data == c.question_id)
    LEFT JOIN $data_answers as a
        ON d.yandexuid == a.yandexuid AND d.survey_id == a.survey_id AND d.question_id_data == a.question_id_data
);


$path = "//home/goda/surveys/data/squeeze/news/" || CAST($end_date AS String);
INSERT INTO $path WITH TRUNCATE
SELECT s.*,
    survey_id as slug,
    req_id ?? answer_req_id as interview_id,
    page_referer ?? answer_referer as referer,
    FALSE as is_required,
    1 as revision_id,
    "news" as supplier_id,
    WITHOUT answer_req_id, req_id, answer_referer, page_referer
    FROM $data_join as s
ORDER BY survey_id, yandexuid, interview_id, question_timestamp, answer_timestamp
;
