import urllib.parse
import json

def remove_prefix(text, prefix):
            if text.startswith(prefix):
                return text[len(prefix):]
            return text

def remove_ru_suffix(text):
    if text.endswith("/ru/"):
        return text[:-3]
    return text

def is_ascii(s):
    return all(ord(c) < 128 for c in s)

def get_encoding(url):
    if not is_ascii(urllib.parse.unquote(url)):
        return urllib.parse.quote(urllib.parse.unquote(url), safe='')
    else:
        return url

def strip_url(url):
    new_url = urllib.parse.unquote(url.replace("https://yandex.ru/turbo?text=", ""))
    new_url = remove_prefix(new_url, "http://")
    new_url = remove_prefix(new_url, "https://")
    new_url = remove_prefix(new_url, "www.")
    new_url = remove_prefix(new_url, "touch.")
    new_url = remove_prefix(new_url, "m.")
    new_url = remove_ru_suffix(new_url)
    return get_encoding(new_url)

def cgi_flags(url):
    x = strip_url(url)
    yandex_flag = {"_site_": [x]}
    cgi_dict = {"0": yandex_flag}
    result = {"system-cgi-params": cgi_dict}
    return json.dumps(result)
