import argparse
import yt.wrapper as yt

def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument(
        '-p',
        dest='pool',
        type=str,
        help='you hahn pool',
    )
    parser.add_argument(
        '-i',
        dest='itable',
        type=str,
        help='input table',
    )
    parser.add_argument(
        '-o',
        dest='ofile',
        type=str,
        help='output file',
    )
    args = parser.parse_args()
    return args


def main():
    args = argument_parser()
    itable = args.itable
    ofile = args.ofile

    last_reqid = "_"
    with open(ofile, "w") as f:
        for i, row in enumerate(yt.read_table(itable)):
            if record[label_name] > 0:
                superior = [i - j for j in range(i) if j not in clicked_indexes]
                clicked_indexes.add(i)
            else:
                inferior = [i - j for j in clicked_indexes if random.random() < 0.5 ** abs(i - j - 1)]

            for el in row['superior_relative']:
                f.write("{}\t{}\n".format(i, i - el))
            for el in row['inferior_relative']:
                f.write("{}\t{}\n".format(i - el, i))

if __name__ == "__main__":
    main()
