import argparse
import csv
import pandas as pd


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument("-i", dest="input", help="full table", required=True)
    parser.add_argument("-o", dest="output", help="output table", required=True)
    return parser.parse_args()


def generate_flag(image, geo, video, entity):
    result_params = '{"system-cgi-params": {"2": {"rearr": ['
    wiz_images = '"scheme_blender/commands/after_calculate_intent_weight/wiz_boost_0={{Cmd:set_intent_pos, on:1, if:\\"1\\", name:WIZIMAGES, pos:\\"{}\\", priority:100, spkey:set_pos_0,spval:\\"1\\"}}",'.format(
        image)
    geov = '"scheme_blender/commands/after_calculate_intent_weight/wiz_boost_1={{Cmd:set_intent_pos, on:1, if:\\"1\\", name:GEOV, pos:\\"{}\\", priority:100, spkey:set_pos_1,spval:\\"1\\"}}",'.format(
        geo)
    videowiz = '"scheme_blender/commands/after_calculate_intent_weight/wiz_boost_2={{Cmd:set_intent_pos, on:1, if:\\"1\\", name:VIDEOWIZ, pos:\\"{}\\", priority:100, spkey:set_pos_2,spval:\\"1\\"}}",'.format(
        video)
    if entity == 100:
        entity_search = '"EntitySearch_off"]}}}'
    else:
        entity_search = '"scheme_blender/commands/after_calculate_intent_weight/wiz_boost_3={{Cmd:set_intent_pos, on:1, if:\\"1\\", name:ENTITY_SEARCH, pos:\\"{}\\", priority:100, spkey:set_pos_3,spval:\\"1\\"}}"]}}}}}}'.format(
            entity)
    return result_params + wiz_images + geov + videowiz + entity_search


def main():
    args = argument_parser()

    df = pd.read_csv(args.input, delimiter="\t", quoting=csv.QUOTE_NONE)
    df = df.replace("None", 100)

    df['cgi'] = df.apply(
        lambda x: generate_flag(x['yandex_images'], x['yandex_geo'], x['yandex_video'], x['yandex_entity']), axis=1)

    df[['query', 'region', 'cgi']].to_csv(args.output, header=None, index=None, sep='\t', quoting=csv.QUOTE_NONE)


if __name__ == "__main__":
    main()
