# coding=utf-8
import argparse


def get_min(val1, val2):
    val1 = 100 if val1 == "None" else int(val1)
    val2 = 100 if val2 == "None" else int(val2)
    return min(val1, val2)


def mean_value(arr, mask):
    if len(mask) == 0:
        return 0, 0
    return sum([float(arr[i][0]) for i in mask]) / len(mask), sum([float(arr[i][1]) for i in mask]) / len(mask)


def union(a, b):
    return a | b


def argument_parser():
    parser = argparse.ArgumentParser(description='Get parameters')
    parser.add_argument("-zt", dest="zero_table", help="path to zero point table", required=True)
    parser.add_argument("-nt", dest="new_table", help="path to zero point table", required=True)
    parser.add_argument("-o", dest="output", help="path of output file", required=True)
    parser.add_argument("--max_pos", dest="max_pos", default=5, type=int)
    return parser.parse_args()


def main():
    args = argument_parser()
    wizards = ["fact", "geo", "video", "entity", "images", "bno", "misspell", "collections", "market", "chats",
               "snippet_image", "recommend"]
    only_ya_wizards = ["collections", "market", "chats"]
    only_g_wizards = ["recommend"]
    wizard_sets = {w: {"yandex": set(), "google": set()} for w in wizards}
    all_q = set()

    maj_vote_results = []
    bt_results = []
    columns = []
    with open(args.zero_table, "r") as zero_table, open(args.new_table, "r") as new_table:
        i = -2
        for zero_line, new_line in zip(zero_table, new_table):
            i += 1
            if i == -1:
                columns = zero_line.strip().split("\t")
                continue
            zero_values, new_values = zero_line.strip().split("\t"), new_line.strip().split("\t")
            row_dict = {columns[i]: (zero_values[i], new_values[i]) for i in range(len(columns))}

            maj_vote_results += [row_dict['majority_vote']]
            bt_results += [row_dict['bradley_terry']]

            all_q.add(i)
            for wiz in wizards:
                if get_min(*row_dict["yandex_{}".format(wiz)]) < args.max_pos:
                    wizard_sets[wiz]["yandex"].add(i)
                if get_min(*row_dict["google_{}".format(wiz)]) < args.max_pos:
                    wizard_sets[wiz]["google"].add(i)

            if zero_values[0] != new_values[0] or zero_values[1] != new_values[1]:
                raise AssertionError

    table_names = ["Есть у Гугла или у Яндекса", "Есть у Гула, но нет у Яндекса", "Есть у Яндекса, но нет у Гугла",
                   "Есть везде"]
    mask_functions = [lambda a, b: a | b,
                      lambda a, b: b - a,
                      lambda a, b: a - b,
                      lambda a, b: a & b]

    with open(args.output, "w") as f:
        i = 0
        for table_name, mask_func in zip(table_names, mask_functions):
            f.write(table_name + "\n")
            f.write("\t\t\tТочка 0\t\tТочка new\n")
            f.write(
                "Срез\tКоличество запросов\tДоля среза\tДоля побед\tBradley-Terry результат\tДоля "
                "побед\tBradley-Terry результат\n")

            if i == 0:
                mask = all_q
                maj_vote_mean = mean_value(maj_vote_results, mask)
                bt_mean = mean_value(bt_results, mask)
                f.write("{}\t{}\t{}\t{}\t{}\t{}\t{}\n".format("total", len(mask),
                                                              1.0 * len(mask) / len(maj_vote_results),
                                                              maj_vote_mean[0], bt_mean[0], maj_vote_mean[1],
                                                              bt_mean[1]))
            for wiz in wizards:
                if wiz in only_ya_wizards and i != 2:
                    continue
                if wiz in only_g_wizards and i != 1:
                    continue
                mask = mask_func(wizard_sets[wiz]["yandex"], wizard_sets[wiz]["google"])
                if wiz != "misspell":
                    all_q = all_q - mask
                maj_vote_mean = mean_value(maj_vote_results, mask)
                bt_mean = mean_value(bt_results, mask)
                f.write("{}\t{}\t{}\t{}\t{}\t{}\t{}\n".format(wiz, len(mask), 1.0 * len(mask) / len(maj_vote_results),
                                                              maj_vote_mean[0], bt_mean[0], maj_vote_mean[1],
                                                              bt_mean[1]))
            if i == 0:
                mask = all_q
                maj_vote_mean = mean_value(maj_vote_results, mask)
                bt_mean = mean_value(bt_results, mask)
                f.write("{}\t{}\t{}\t{}\t{}\t{}\t{}\n".format("snippets", len(mask), 1.0 * len(mask) / len(maj_vote_results),
                                                              maj_vote_mean[0], bt_mean[0], maj_vote_mean[1],
                                                              bt_mean[1]))
            i += 1

            f.write("\n\n")


if __name__ == "__main__":
    main()
