from nile.api.v1 import (
    Record,
    clusters,
    statface,
    extractors as ne,
    filters as nf,
    aggregators as na,
    modified_schema,
    with_hints,
    cli
)
from qb2.api.v1 import typing as qt


def parse_event_value(raw_dict):
    try:
        event_dict = eval(raw_dict.replace("false", "False").replace("true", "True").replace("null", "''"))
        return event_dict
    except:
        return {}


def check_param_equal(event_value, param, target):
    return parse_event_value(event_value).get(param, "none") in target


@cli.statinfra_job
def make_job(job, options, statface_client):
    report = statface.report.StatfaceReport(
        path="Distribution/Adhoc/searchlib/bar_clicks",
        scale="daily",
        replace_mask="fielddate",
        client=statface_client
    )

    squeeze_table = job.table(
        "//home/searchlib/squeeze/@dates"
    ).filter(
        nf.equals("EventType", 4),  # EVENT_CLIENT
        nf.custom(lambda x: options.dates[0] <= x <= options.dates[-1], "EventDate")
    ).project(
        "DeviceID", "EventName", "EventValue",
        apikey=ne.custom(lambda x: str(x), "APIKey").with_type(str),
        fielddate="EventDate",
        version=ne.custom(lambda x: parse_event_value(x).get("version", "none"), "EventValue").with_type(str)
    )

    informers = squeeze_table.filter(
        nf.equals("EventName", "searchlib_informer_clicked"),
        nf.custom(lambda x: parse_event_value(x).get("kind", "none") == "bar", "EventValue")
    ).project(
        ne.all(),
        element=ne.custom(lambda x: parse_event_value(x).get("informer", "none"), "EventValue").with_type(str)
    )

    bar_element = squeeze_table.filter(
        nf.equals("EventName", "searchlib_bar_element_clicked")
    ).project(
        ne.all(),
        element=ne.custom(lambda x: parse_event_value(x).get("element", "none"), "EventValue").with_type(str)
    )

    bar_clicked = squeeze_table.filter(
        nf.equals("EventName", "searchlib_bar_clicked")
    )

    all_bar_clicked = bar_clicked.project(
        ne.all(),
        element=ne.const("searchlib_bar_clicked")
    )

    split_bar_clicked = bar_clicked.project(
        ne.all(),
        open_serp=ne.custom(lambda x: parse_event_value(x).get("open_serp", "none"), "EventValue").with_type(bool),
        trend=ne.custom(lambda x: parse_event_value(x).get("trend", "none"), "EventValue").with_type(bool),
        voice=ne.custom(lambda x: parse_event_value(x).get("voice", "none"), "EventValue").with_type(bool)
    )

    find_element = split_bar_clicked.filter(
        nf.equals("open_serp", True),
        nf.equals("trend", True)
    ).project(
        "DeviceID", "EventName", "EventValue",
        "apikey",
        "fielddate",
        "version",
        element=ne.const("find")
    )

    voice_element = split_bar_clicked.filter(
        nf.equals("voice", True)
    ).project(
        "DeviceID", "EventName", "EventValue",
        "apikey",
        "fielddate",
        "version",
        element=ne.const("voice")
    )

    all_elements_table = job.concat(
        informers,
        bar_element,
        find_element,
        voice_element,
        all_bar_clicked
    )

    job.concat(
        all_elements_table.groupby(
            "apikey", "version", "fielddate", "element"
        ).aggregate(
            click_count=na.count()
        ),

        all_elements_table.groupby(
            "apikey", "fielddate", "element"
        ).aggregate(
            click_count=na.count()
        ).project(
            ne.all(),
            version=ne.const("_total_")
        ),

        all_elements_table.groupby(
            "version", "fielddate", "element"
        ).aggregate(
            click_count=na.count()
        ).project(
            ne.all(),
            apikey=ne.const("_total_")
        ),

        all_elements_table.groupby(
            "fielddate", "element"
        ).aggregate(
            click_count=na.count()
        ).project(
            ne.all(),
            version=ne.const("_total_"),
            apikey=ne.const("_total_")
        )
    ).publish(
        report
    )

    return job


if __name__ == "__main__":
    cli.run()
