import os
import urllib.request

import json

#isDebugMode = True
isDebugMode = False
encoding = 'utf8'
tabChar = '\t'
newLineChar = '\n'

def debug(param):
    if isDebugMode :
        print(param)  

def getFileNames(substr):
    ls = os.listdir()
    tsvList = []
    
    for filename in ls:
        if filename.endswith(substr) :
            tsvList.append(filename)
            
    return tsvList

def joinToMatrix(tsvList):
    matrix = []
    
    for filename in tsvList:
        with open(filename) as f:
            l = f.read().splitlines()
            l.insert(0, filename + tabChar*l[0].count(tabChar))
            matrix.append(l)
            
    return matrix

def loadMatrixFromFile(filename):
    matrix = []
    
    with open(filename) as f:
        lines = f.read().splitlines()

    for line in lines:
        matrix.append(line.split(tabChar))

    return matrix

def printMatrixToFileTransponed(filename, matrix):
    f = open(filename, 'w')
    line = ''
    
    for j in range(len(matrix[0])):
        for i in range(len(matrix)):
            line += str(matrix[i][j]) + tabChar
        f.write(line[:-1] + newLineChar)
        line = ''
                
    f.close()

def printMatrixToFile(filename, matrix):
    f = open(filename, 'w')
    line = ''

    for i in range(len(matrix)):
        for j in range(len(matrix[0])):
            line += str(matrix[i][j]) + tabChar
        f.write(line[:-1] + newLineChar)
        line = ''
        
    f.close()

def getHttpResponse(url):
    responseBinary = ''
    
    with urllib.request.urlopen(url) as f:
        responseBinary = f.read()

    return str(responseBinary, encoding=encoding) #binary mode is default in Python 3

def getHttpResponseLines(url):
    return getHttpResponse(url).splitlines()

def getPfoundPlotTsv(formula, pool):
    return getHttpResponseLines('https://fml.yandex-team.ru/download/computed/formula?id='+formula+'&file=pfound_plot_pool_'+pool+'.tsv')

def joinToMatrixHttp(formulae, pool):
    matrix = []
    
    for formula in formulae:
        try :
            l = getPfoundPlotTsv(formula, pool)
            addTabs = tabChar * l[0].count(tabChar)
            l.insert(0, addTabs + formula)
            l[1] = addTabs + getFormulaJson(formula)['description']
            matrix.append(l)
        except urllib.error.HTTPError as e :
            progress = ''
            try :
                #progressJson = getProgressJson(formula)
                progress = 'unknown' #progressJson['progress']
                #if progressJson['status'] == 'COMPLETED':
                #progress += ' plot: ' + json.dumps(submitFormulaPlotCalc(formula, pool), sort_keys = True, indent = 4, separators=(',', ': '))
            except BaseException as ex :
                print(formula, ex)
            print(formula, 'Progress: ' + str(progress))
        except BaseException as e :
            print(formula, str(e))

    matrix[0][1] = 'Trees' + matrix[0][1]   
    return matrix

def getJsonFromUrl(url):
    response = getHttpResponse(url)
    data = json.loads(response)
    debug(json.dumps(data, sort_keys = True, indent = 4, separators=(',', ': ')))
    return data

def getFormulaJson(formula):
    return getJsonFromUrl('https://fml.yandex-team.ru/rest/api/formula/fml/' + formula)

def submitFormulaPlotCalc(formula, pool):
    return getJsonFromUrl('https://fml.yandex-team.ru/submit/formula/plot?pool-id=' + pool + '&formula-id=' + formula)


def getProgressJson(formula):
    return getJsonFromUrl('http://fml.yandex-team.ru/view/progress?type=MATRIX_NET_FORMULA_CPU&progress-id=' + formula)

def removeDulicateTreeNumbers(matrix):
    newMatrix = []

    for line in matrix:
        newLine = []
        for i in range(len(line)):
            if i <= 1 or i%2 == 1: 
                newLine.append(line[i])
        newMatrix.append(newLine)

    return newMatrix

def addAvgResults(matrix):
    newMatrix = [matrix[0]] #Trees
    totalSum = [0] * len(matrix[0])
    totalCount = 0
    isRecording = False

    for i in range(1, len(matrix)):
        if '#' in matrix[i][1]: #A C D
            if matrix[i-1][1].split('#')[0] == matrix[i][1].split('#')[0] and isRecording:
                debug(str(i) + ' C')
                totalCount += 1
                totalSum[0] += ',' + matrix[i][0] #formula id
                for j in range(2, len(matrix[i])): #sum pfound
                    if len(matrix[i][j]) > 0 :
                        totalSum[j] += float(matrix[i][j])
            else :
                if isRecording :
                    debug(str(i) + ' D')
                    
                    for j in range(2, len(totalSum)): #AVG pfound
                        if len(matrix[i][j]) > 0 :
                            totalSum[j] = float(totalSum[j]) / float(totalCount)
                    totalSum[1] += ' x' + str(totalCount)
                    newMatrix.append(totalSum)
                    
                    totalCount = 0
                    totalSum = [0] * len(matrix[i])
                
                debug(str(i) + ' A')
                isRecording = True
                totalCount = 1
                totalSum[0] = matrix[i][0] #formula id
                totalSum[1] = matrix[i][1].split('#')[0] #formula description
                for j in range(2, len(matrix[i])): #pfound init
                    if len(matrix[i][j]) > 0 :
                        totalSum[j] = float(matrix[i][j])
        else :
            debug(str(i) + ' B')
            isRecording = False
            newMatrix.append(matrix[i])

    if isRecording:
        debug(str(i) + ' E')

        for j in range(2, len(totalSum)): #AVG pfound
            if len(matrix[i][j]) > 0 :
                totalSum[j] = float(totalSum[j]) / float(totalCount)
        totalSum[1] += ' x' + str(totalCount)
        newMatrix.append(totalSum)
                    
    return newMatrix          
                
def addPfoundPlot(formulae, pool):
    for formula in formulae:
        print(formula + ' plot ' + submitFormulaPlotCalc(formula, pool)['status'])

#matrix = joinToMatrix(getFileNames(".tsv"))
#printMatrixToFileTransponed("matrix.tsv", matrix)

#tr mse
formulae = ['65780','66441','66442','66443','66444','66445','66446','66447','66448','66449',
            '66450','66451','66452','66453','66454','66455','66456','66457','66525','66526',
            '66527','66528','66529','66530']
pools = ['482425']

#kubr mse
##formulae = ['66209','66208','66210','66199','65881','66201','66200','66203','66202','66205',
##            '66204','66207','66206','66477','66478','66479','66480','66481','66482','66483',
##            '66484','66485','66486','66487','66488','66631','66632','66633','66634','66635',
##            '66636','66637','66638','66639','60345','60346','60347','66819','66820','66821',
##            '66822','66823','66824','66891','66892','66893','66894','66895','66896','66897',
##            '66898','66899']
##formulae.sort()
##pools = ['482506', '484700', '483797'] #all kubr, kubr long tail, ru long tail

##addPfoundPlot(formulae, '483797')

for pool in pools:
    rawResultFileName = "raw_comparison_on_pool_" + pool + ".tsv"
    beautyResultFileName = "comparison_on_pool_" + pool + ".tsv"
    avgResultFileName = "avg_comparison_on_pool_" + pool + ".tsv"

    matrix = joinToMatrixHttp(formulae, pool)
    printMatrixToFileTransponed(rawResultFileName, matrix)

    matrix = loadMatrixFromFile(rawResultFileName)
    printMatrixToFileTransponed(beautyResultFileName, removeDulicateTreeNumbers(matrix))

    matrix = loadMatrixFromFile(beautyResultFileName)
    printMatrixToFileTransponed(avgResultFileName, addAvgResults(matrix))


        


        
